% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R, R/calcstats.R
\name{segregation_index}
\alias{segregation_index}
\alias{redist.segcalc}
\title{Segregation index calculation for MCMC redistricting.}
\usage{
segregation_index(
  map,
  group_pop,
  total_pop = map[[attr(map, "pop_col")]],
  .data = cur_plans()
)

redist.segcalc(plans, group_pop, total_pop)
}
\arguments{
\item{map}{a \code{\link{redist_map}} object}

\item{group_pop}{A vector of populations for some subgroup of interest.}

\item{total_pop}{A vector containing the populations of each geographic unit.}

\item{.data}{a \code{\link{redist_plans}} object}

\item{plans}{A matrix of congressional district assignments or a
redist object.}
}
\value{
\code{redist.segcalc} returns a vector where each entry is the
dissimilarity index of segregation (Massey & Denton 1987) for each
redistricting plan in \code{algout}.
}
\description{
\code{redist.segcalc} calculates the dissimilarity index of segregation (see
Massey & Denton 1987 for more details) for a specified subgroup under any
redistricting plan.
}
\examples{
\donttest{
data(fl25)
data(fl25_enum)
data(fl25_adj)

## Get an initial partition
init_plan <- fl25_enum$plans[, 5118]

## 25 precinct, three districts - no pop constraint ##
alg_253 <- redist.flip(
    adj = fl25_adj, total_pop = fl25$pop,
    init_plan = init_plan, nsims = 10000
)

## Get Republican Dissimilarity Index from simulations
rep_dmi_253 <- redist.segcalc(alg_253, fl25$mccain, fl25$pop)
}
}
\references{
Fifield, Benjamin, Michael Higgins, Kosuke Imai and Alexander
Tarr. (2016) "A New Automated Redistricting Simulator Using Markov Chain
Monte Carlo." Working Paper. Available at
\url{http://imai.princeton.edu/research/files/redist.pdf}.

Massey, Douglas and Nancy Denton. (1987) "The Dimensions of Social
Segregation". Social Forces.
}
\concept{analyze}
