% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compactness.R
\name{comp_lw}
\alias{comp_lw}
\title{Calculate Length Width Compactness}
\usage{
comp_lw(plans, shp, epsg = 3857, ncores = 1)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object or tibble with sf geometry column}

\item{epsg}{numeric EPSG code to planarize to. Default is 3857.}

\item{ncores}{numeric. Number of cores to use. Default is 1.}
}
\value{
numeric vector
}
\description{
Calculate Length Width Compactness
}
\examples{
data(nh)
data(nh_m)
# For a single plan:
comp_lw(plans = nh$r_2020, shp = nh)

# Or many plans:
\donttest{
# slower, beware!
comp_lw(plans = nh_m[, 3:5], shp = nh)
}

}
\references{
Harris, Curtis C. 1964. “A scientific method of districting”.
Behavioral Science 3(9), 219–225.
}
\concept{compactness}
