% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/incumbent.R
\name{inc_pairs}
\alias{inc_pairs}
\title{Count Incumbent Pairings}
\usage{
inc_pairs(plans, shp, inc)
}
\arguments{
\item{plans}{redist_plans object or plans_matrix where each row indicates a district assignment and each column is a plan}

\item{shp}{redist_map object, tibble, or data frame containing other columns}

\item{inc}{unqouted name of logical column in shp indicating where incumbents live}
}
\value{
vector of number of incumbents paired
}
\description{
Count the number of incumbents paired with at least one other incumbent.
}
\examples{
data(nh)
data(nh_m)
# Use incumbent data:
fake_inc <- rep(FALSE, nrow(nh))
fake_inc[3:4] <- TRUE

# For a single plan:
inc_pairs(plans = nh$r_2020, shp = nh, inc = fake_inc)

# Or many plans:
inc_pairs(plans = nh_m[, 3:5], shp = nh, inc = fake_inc)

}
\concept{incumbent}
