% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/change_functions.R
\name{getAreaLoss}
\alias{getAreaLoss}
\title{Area change between two inputs in km2}
\usage{
getAreaLoss(x, y)
}
\arguments{
\item{x}{RasterLayer or SpatialPolygons object of distribution or Numeric
representing area in km2}

\item{y}{RasterLayer or SpatialPolygons object of distribution or Numeric
representing area in km2}
}
\value{
Returns the difference in area of the two inputs in km2
}
\description{
\code{getAreaLoss} reports the difference in area between two inputs. These
can be RasterLayers, SpatialPolygons, or numbers. Any combinations of these
inputs are valid. If using number as input, ensure it is measured in km2
}
\examples{
crs.UTM55S <- '+proj=utm +zone=55 +south +ellps=WGS84 +datum=WGS84 +units=m +no_defs'
r1 <- raster(ifelse((volcano<130), NA, 1), crs = crs.UTM55S)
extent(r1) <- extent(0, 6100, 0, 8700)
r2 <- raster(ifelse((volcano<145), NA, 1), crs = crs.UTM55S)
extent(r2) <- extent(0, 6100, 0, 8700)
a.dif <- getAreaLoss(r1, r2) # distribution rasters
}
\seealso{
Other Change functions: \code{\link{getArea}},
  \code{\link{getDeclineStats}}
}
\author{
Nicholas Murray \email{murr.nick@gmail.com}, Calvin Lee
  \email{calvinkflee@gmail.com}
}
