% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gridUncertainty_functions.R
\name{gridUncertaintySimulation}
\alias{gridUncertaintySimulation}
\title{Function to investigate behaviour of AOO under various split scenarios}
\usage{
gridUncertaintySimulation(input.data, grid.size, simulations,
  min.percent.rule = FALSE, percent = 1)
}
\arguments{
\item{input.data}{Object of an ecosystem or species distribution. Accepts either
raster or spatial points formats. Please use a CRS with units measured in
metres.}

\item{grid.size}{A number specifying the width of the desired grid square (in
same units as your coordinate reference system)}

\item{simulations}{Specifies the maximum number of splits to be performed on
the generated grid}

\item{min.percent.rule}{Logical. If \code{TRUE}, a minimum area threshold
must be passed before a grid is counted as an AOO grid.}

\item{percent}{Numeric. The minimum percent to be applied as a threshold for
the \code{min.percent.rule}.}
}
\value{
Data frame of results showing the minimum and maximum AOO calculated
  for each grid shift scenario.
}
\description{
\code{gridUncertaintySimulation} returns the maximum and minimum number of
area of occupancy (AOO) grid cells occupied by a species or ecosystem in
incremental splits using \code{gridUncertaintyBase}.
}
\seealso{
Other gridUncertainty functions: \code{\link{gridUncertaintyBase}},
  \code{\link{gridUncertaintyRandomManual}},
  \code{\link{gridUncertaintyRandom}},
  \code{\link{gridUncertaintyRestricted}},
  \code{\link{gridUncertainty}}
}
\author{
Calvin Lee \email{calvinkflee@gmail.com}
}
\concept{gridUncertainty functions}
