% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refitME_package.r
\name{MCEMfit_gen}
\alias{MCEMfit_gen}
\title{Function for fitting any likelihood-based model using the MCEM algorithm}
\usage{
MCEMfit_gen(
  mod,
  family,
  sigma.sq.u,
  B = 50,
  epsilon = 1e-05,
  silent = FALSE,
  theta.est = 1,
  shape.est = 1,
  ...
)
}
\arguments{
\item{mod}{: a model object (this is the naive fitted model). Make sure the first \eqn{p} input predictor variables entered in the naive model are the specified error-contaminated variables. These \eqn{p} predictors also need the measurement error variance to be specified in \code{sigma.sq.u}, see below.}

\item{family}{: a specified family/distribution.}

\item{sigma.sq.u}{: measurement error (ME) variance. A scalar if there is only one error-contaminated predictor variable, otherwise this must be stored as a vector (of ME variances) or a matrix if the ME covariance matrix is known.}

\item{B}{: the number of Monte Carlo replication values (default is set to 50).}

\item{epsilon}{: a set convergence threshold (default is set to 0.00001).}

\item{silent}{: if \code{TRUE}, the convergence message (which tells the user if the model has converged and reports the number of iterations required) is suppressed (default is set to \code{FALSE}).}

\item{theta.est}{: an initial value for the dispersion parameter (this is required for fitting negative binomial models).}

\item{shape.est}{: an initial value for the shape parameter (this is required for fitting gamma models).}

\item{...}{: further arguments passed through to the function that was used to fit \code{mod}, that will be used in refitting. These need only be specified if making changes to the arguments as compared to the original call that produced \code{mod}.}
}
\value{
\code{MCEMfit_gen} returns the original naive fitted model object but coefficient estimates and residuals have been replaced with the final MCEM model fit. Standard errors are included and returned, if \code{mod} is a class of object accepted by the \pkg{sandwich} package (such as \code{glm}, \code{gam}, \code{survreg} and many more).
}
\description{
Function for wrapping the MCEM algorithm on any likelihood-based model where predictors are subject to measurement error/error-in-variables.
}
\references{
Carroll, R. J., Ruppert, D., Stefanski, L. A., and Crainiceanu, C. M. (2006). \emph{Measurement Error in Nonlinear Models: A Modern Perspective.} 2nd Ed. London: Chapman & Hall/CRC.

Stoklosa, J., Hwang, W-H., and Warton, D.I. \pkg{refitME}: Measurement Error Modelling using Monte Carlo Expectation Maximization in \proglang{R}.
}
\seealso{
\code{\link{MCEMfit_glm}} and \code{\link{MCEMfit_gam}}
}
\author{
Jakub Stoklosa, Wen-Han Hwang and David I. Warton.
}
