% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pffr-methods.R
\name{residuals.pffr}
\alias{residuals.pffr}
\alias{fitted.pffr}
\title{Obtain residuals and fitted values for a pffr models}
\usage{
\method{residuals}{pffr}(object, reformat = TRUE, ...)

\method{fitted}{pffr}(object, reformat = TRUE, ...)
}
\arguments{
\item{object}{a fitted \code{pffr}-object}

\item{reformat}{logical, defaults to TRUE. Should residuals be returned in
\code{n x yindex} matrix form (regular grid data) or, respectively, in the
shape of the originally supplied \code{ydata} argument (sparse/irregular
data), or, if \code{FALSE}, simply as a long vector as returned by
\code{resid.gam()}?}

\item{...}{other arguments, passed to \code{\link[mgcv]{residuals.gam}}.}
}
\value{
A matrix or \code{ydata}-like \code{data.frame} or a vector of
  residuals / fitted values (see \code{reformat}-argument)
}
\description{
See \code{\link{predict.pffr}} for alternative options to extract estimated
values from a \code{pffr} object.
"Fitted values" here refers to the estimated additive predictor values,
these will not be on the scale of the response for models with link functions.
}
\author{
Fabian Scheipl
}
