% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derivatives.r
\name{d_phi}
\alias{d_phi}
\title{Partial derivatives for mean impact equation.}
\usage{
d_phi(
  p_impact,
  etable,
  theta,
  mean_predictors,
  var_predictors,
  cov,
  samp_size,
  num_items,
  num_quad
)
}
\arguments{
\item{p_impact}{Vector of impact parameters.}

\item{etable}{E-table for impact.}

\item{theta}{Matrix of adaptive theta values.}

\item{mean_predictors}{Possibly different matrix of predictors for the mean
impact equation.}

\item{var_predictors}{Possibly different matrix of predictors for the
variance impact equation.}

\item{cov}{Covariate being maximized.}

\item{samp_size}{Sample size in dataset.}

\item{num_items}{Number of items in dataset.}

\item{num_quad}{Number of quadrature points used for approximating the
latent variable.}
}
\value{
a \code{"list"} of first and second partial derivatives for variance impact equation (to
use with coordinate descent and univariate Newton-Raphson)
}
\description{
Partial derivatives for mean impact equation.
}
\keyword{internal}
