% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build_model.R
\name{build_model}
\alias{build_model}
\title{Incremental block modelling.}
\usage{
build_model(dv, ..., data = NULL, opts = NULL, model = "lm")
}
\arguments{
\item{dv}{The variable name to be used as the dependent variable.}

\item{...}{Pass through variable names (or interaction terms) to add for each
block. To add one term to a block, just pass it through directly; to
add multiple terms, pass it through in a vector or list. Blocks will be
added in the order they are passed to the function, and variables from
previous blocks will be included with each subsequent block.}

\item{data}{An optional data frame containing the variables in the model. If
not found in \code{data}, the variables are taken from the environment from
which the function is called.}

\item{opts}{List of arguments to be passed to the model function.}

\item{model}{The type of model to use; only supports 'lm' at this time.}
}
\value{
A named list with the following elements:
\tabular{ll}{
  \code{formulas} \tab A list of the regression formulas used for each block.
  \cr
  \code{models} \tab A list of all regression models.\cr
}
}
\description{
\code{build_model} allows you to incrementally add terms to a linear regression
model.
}
\details{
Given a list of names of variables at each step, this function will run a
series of models, adding the terms for each block incrementally.

Note: Cases with missing data are dropped based on the final model that
includes all the relevant terms. This ensures that all the models are tested
on the same number of cases.
}
\examples{
# 2 blocks: Petal.Length; Petal.Length + Petal.Width
model1 <- build_model(Sepal.Length, Petal.Length, Petal.Width, data=iris, model='lm')
summary(model1)
coef(model1)

# 2 blocks: Species; Species + Petal.Length + Petal.Width + Petal.Length:Petal.Width
model2 <- build_model(Sepal.Length, Species, c(Petal.Length * Petal.Width), data=iris, model='lm')
summary(model2)
coef(model2)
}

