% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/code_generate.R
\name{nn_model}
\alias{nn_model}
\title{nn_model}
\usage{
nn_model(data = "datos.aprendizaje", variable.pred = NULL,
  model.var = "modelo.nn", mean.var = "mean.nn", sd.var = "sd.nn",
  threshold = 0.01, stepmax = 1000, cant.hidden = 2, ...)
}
\arguments{
\item{data}{the name of the learning data.}

\item{variable.pred}{the name of the variable to be predicted.}

\item{model.var}{the name of the variable that stores the resulting model.}

\item{mean.var}{the name of the variable that stores the mean of the columns.}

\item{sd.var}{the name of the variable that stores the standard deviation of the columns.}

\item{threshold}{the threshold parameter of the model.}

\item{stepmax}{the stepmax parameter of the model.}

\item{cant.hidden}{the quantity of hidden layers that are going to be used.}

\item{...}{a vector with the number of nodes in each hidden layer.}
}
\description{
generates the code to create the neural network model.
}
\examples{
\dontrun{
library(neuralnet)
library(dummies)

x <- nn_model('iris', 'Petal.Length','modelo.nn', 'mean.nn', 'sd.nn', 0.05, 2000, 3, 30, 50, 80)
exe(x)

print(modelo.nn)
print(mean.nn)
print(sd.nn)
}
}
\seealso{
\code{\link[neuralnet]{neuralnet}}
}
