% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/furcation-class.R
\docType{class}
\name{ftree-class}
\alias{ftree-class}
\alias{ftree}
\title{An S4 class to represent a furcation tree on one side of one allele of a focal marker}
\description{
An S4 class to represent a furcation tree on one side of one allele of a focal marker
}
\details{
A furcation structure consists of two trees ("left" and "right") for each allele of
a focal marker. If there are only bi-allelic markers
and no missing values, the trees are bifurcating.

Missing values are treated similarly to an extra allele
in so far as they cause a furcation. However, the resulting daughter node is marked
accordingly and the chromosomes excluded from further calculations.
If all chromosomes of a parent node have missing values, the "furcation" is
degenerated and yields a single daughter node.

Note that a tree with n leaves can have at most 2n-1 nodes.

In a furcation tree, the leaves do not necessarily represent
single chromosomes, either due to multiple missing data or
because the first/last marker was reached before all
extended haplotypes were distinct.
}
\section{Slots}{

\describe{
\item{\code{node_parent}}{a vector, representing the tree structure. 
Each node (number) is assigned its parent node (number).}

\item{\code{node_pos}}{a vector, assigning to each node (number) its position in the chromosome, i.e.
at which marker position the furcation occurred.}

\item{\code{node_with_missing_data}}{a vector of type \code{logical}. 
Pseudo-furcations arise due to missing data at a marker.
The daughter node (number) is marked accordingly.}

\item{\code{label_parent}}{a vector, that attaches an "extra leave", representing
the haplotype number (defined by the order in the haplotype data file) to leaves
of the tree.
This is necessary because in general not all leaves of the original tree represent
a single haplotype/chromosome.}
}}

