% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcFStats.R
\name{calcFStats}
\alias{calcFStats}
\title{Calculate locus-wise and population \eqn{\theta = F_{ST}}{theta = F_ST},  \eqn{F = F_{IT}}{F = F_IT}, and \eqn{f = F_{IS}}{f = F_IS} values}
\usage{
calcFStats(Pop, subPopIdx = NULL)
}
\arguments{
\item{Pop}{An object type 'population'}

\item{subPopIdx}{If this vector is not null, then it must consist of
\eqn{N}{N} elements with values from 1 to \eqn{n_s}{ns} representing which
subpopulation each member of \code{Pop$profiles} belongs to. If it is null
then it is assumed that the population consists of \eqn{n_s}{ns}
subpopulations of equal size \eqn{N_s}{Ns} so that \eqn{n_s\times N_s =
N}{ns*Ns = N}}
}
\value{
A vector of length \eqn{n_{loci}+1}{nloci+1} with locus-wise
\eqn{\theta}{theta} values and an overall \eqn{\theta}{theta} value for the
population
}
\description{
This procedure uses the method of Weir and Cockerham to estimate
\eqn{\theta = F_{ST}}{theta = F_ST},  \eqn{F = F_{IT}}{F = F_IT}, and \eqn{f = F_{IS}}{f = F_IS} for a population with known substructure
}
\examples{

data(USCaucs)
set.seed(123)
p = breedFst(USCaucs)
fstats = calcFStats(p)
fstats

}
\references{
Weir, B.S., Genetic Data Analysis II, (1996) p.173--179,
Sinauer, Sunderland, MA.
}
\seealso{
breedFst
}
\author{
James M. Curran
}
