\name{paf}

\alias{paf}

\title{Principal Axis Factoring}

\description{This function performs a prinxipal axis factor analysis providing the user with a set
of preliminary informative estimates regarding the dimensionality and scale functioning of the submitted items. 
The function does not allow for rotations and is by no means considered a full factor analysis tool, but rather 
a supplemental module.}

\usage{paf(object, eigcrit=1, convcrit=.001)}

\arguments{

	\item{object}{Numeric dataset (usually a coerced matrix from a prior data frame) containing all items of the scale. The dataset is arranged observations (rows) by measure items (columns). }
	
	\item{eigcrit}{Eigenvalue criterion cut-off to be used in the iterative estimation process. By default set to use all eigenvalues greater than 1.}
	
	\item{convcrit}{The convergence criterion determining the number of iterations by computing difference scores between prior and estimated communalities. By default set to be less than .001 for each compared cell. }
}

\details{This function is intended as a companion to the itemanal() function in this package (rela). Its primiary goal is to provide the researcher with additional information when exploring the dimensionality and reliability of a scale. 
Moreover, the when called the function will produce four plots: A scree plot of the eigenvalues of the original correlation matrix, a plot of the measure of sampling adequacy values for each item, a comparative plot for the initial and 
final communalities, and a plot series for the correlation residuals for each individual item against all other items.}

\value{

Output consists of a list with the following values:\cr

	\item{Correlation}{Correlation matrix of the submitted dataset. }

	\item{Anti.Image.Cov}{The Anti Image Covariance Matrix. }

	\item{Anti.Image.Cor}{The Anti Image Correlation Matrix. }

	\item{KMO}{The Kaiser-Meyer-Olkin measure of sampling adequacy test.}

	\item{MSA}{Individual measures of sampling adequacy for each item. }

	\item{Bartlett}{Bartlett's Test of Sphericity for covariance matrices. }

	\item{Communalities}{Initial and final communality extractions. }

	\item{Iterations}{Number of iterations needed to meet convergence criterion. }

	\item{Eigenvalues}{All eigenvalues for extracted at each iteration. }

	\item{Communality.Iterations}{All estimated communalities for each iteration submited to the convergence test. }

	\item{Criterion.Differences}{Difference scores between estimated communalities. }

	\item{Factor.Loadings}{Final item factor loadings on extracted latent components. }

	\item{Reproduced.Cor}{Factor loading reproduced correlation matrix. }

	\item{Residuals}{Correlation residuals (observed minus reproduced correlations). }

	\item{RMS}{Root mean square errors (of the correlation residuals). }

	\item{call}{Submitted arguments to the paf() function. }

}

\references{
Cronbach, L. J. (1951). Coefficient alpha and the internal structure of tests. \emph{Psychometrika, 16(3)}, 297-334. \cr
\cr
Duhachek, A. & Iacobucci, D. (2004). Alpha's standard error (ASE): An accurate and precise confidence interval estimate. \emph{Journal of Applied Psychology, 89(5)}, 792-808. \cr
\cr
Kim, J., & Mueller, C. W. (1978). \emph{Introduction to factor analysis: What it is and how to do it}. SAGE Publications: Newbury Park, CA. \cr
\cr
Nunnally, J. C. & Bernstein, I. H. (1994). \emph{Psychometric theory} (3 ed.). McGraw-Hill: New York, NY. \cr
\cr
Kaiser, H. F. & Cerny, B. A. (1979). Factor analysis of the image correlation matrix. \emph{Educational and Psychological Measurement}, 39, 711-714.\cr
\cr
Pett, M. A., Lackey, N. R., & Sullivan, J. J. (2003). \emph{Making sense of factor analysis: The use of factor analysis for instrument development in health care research}. SAGE Publications: Thousand Oaks, CA.}


\author{Michael Chajewski ( \url{http://www.chajewski.com} )}

\note{Under the current version of this function/package missing data is deleted listwise. Subsequently only full cases are used in determining scale reliability.}

\examples{

library(rela)

Belts <- Seatbelts[,1:7]
summary(Belts)

paf.belt <- paf(Belts)
paf.belt

Belts2 <- Belts[,-5]
Belts2 <- Belts2[,-5] 

paf.belt2 <- paf(Belts2)
paf.belt2
}

\concept{mulivariate}
\concept{paf}
\concept{rela}
\concept{principal axis}
\concept{factor analysis}
\concept{chajewski}
\concept{scale}


\keyword{manip}
\keyword{misc}
