\name{CodeChunkPlayer}
\alias{CodeChunkPlayer}
\alias{ConstructDemo}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{CodeChunkPlayer, ConstructDemo -- tools for browsing and evaluation of code chunks}
\description{
  \code{CodeChunkPlayer} enables the user to evaluate code chunks interactively.
  \code{ConstructDemo} constructs a demo function from a file containing code chunks.
}
\usage{
  CodeChunkPlayer(file="")
  ConstructDemo(file="")
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{file}{name of rev-, Snw-file or .R-file containing code chunks}
}
\details{
  Both functions need a .R-file that has been generated by \code{tangleR}.
  If the input file is not a .R-file but an rev-file or an Snw-file the input file 
  will be tangled by \code{tangleR} and a .R-file will be generated.  

  \code{CodeChunkPlayer}:
  \code{CodeChunkPlayer} extracts the code chunks stored in the .R-file and 
  creates a Tcl/Tk window to show a code chunk selected by the user. 
  The user can browse through 
  the set of chunks by clicking on \code{NEXT} or b\code{BACK} or by typing
  the number of a code chunk. The code of the selected code chunk is shown 
  in the text field of the player window and may be edited. By clicking button 
  \code{EVALUATE} the code will be evaluated and the output occurs on the R console.

  \code{ConstructDemo}: 
  \code{ConstructDemo} extracts the code chunks of the .R-file and builds a new
  function for browsing through the code chunks. This function will contain the code 
  chunks of the .R-file as well as the logic for browsing and evaluation of selected chunks.
  The function is stored with its call in a file whose name is composed 
  from the name of the input file and the extension \code{.demo.R}. Therefore, you can 
  start the demo function by e.g. \code{source("xyz.demo.R")} and 
  a Tcl/Tk window for code chunk browsing will be created. 
  This window works like the Tcl/Tk window that is generated by \code{CodeChunkPlayer}.  
}
\value{

  \code{CodeChunkPlayer} and \code{ConstructDemo} don't have any explicit result.
}
\references{\url{http://www.wiwi.uni-bielefeld.de/com/wolf/software/relax.html}}
\author{Hans Peter Wolf}
\examples{
## CodeChunkPlayer()
## ConstructDemo()
}
\keyword{ misc }% at least one, from doc/KEYWORDS

