% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/snapshot.R
\name{snapshot}
\alias{snapshot}
\title{Snapshot a Project}
\usage{
snapshot(
  project = NULL,
  ...,
  library = NULL,
  lockfile = paths$lockfile(project = project),
  type = settings$snapshot.type(project = project),
  repos = getOption("repos"),
  packages = NULL,
  prompt = interactive(),
  update = FALSE,
  force = FALSE,
  reprex = FALSE
)
}
\arguments{
\item{project}{The project directory. If \code{NULL}, then the active project will
be used. If no project is currently active, then the current working
directory is used instead.}

\item{...}{Unused arguments, reserved for future expansion. If any arguments
are matched to \code{...}, \code{renv} will signal an error.}

\item{library}{The \R libraries to snapshot. When \code{NULL}, the active \R
libraries (as reported by \code{.libPaths()}) are used.}

\item{lockfile}{The location where the generated lockfile should be written.
By default, the lockfile is written to a file called \code{renv.lock} in the
project directory. When \code{NULL}, the lockfile (as an \R object) is returned
directly instead.}

\item{type}{The type of snapshot to perform. See \strong{Snapshot Type} for
more details.}

\item{repos}{The \R repositories to be recorded in the lockfile. Defaults
to the currently active package repositories, as retrieved by
\code{getOption("repos")}.}

\item{packages}{A vector of packages to be included in the lockfile. When
\code{NULL} (the default), all packages relevant for the type of snapshot being
performed will be included. When set, the \code{type} argument is ignored.
Recursive dependencies of the specified packages will be added to the
lockfile as well.}

\item{prompt}{Boolean; prompt the user before taking any action? For backwards
compatibility, \code{confirm} is accepted as an alias for \code{prompt}.}

\item{update}{Boolean; if the lockfile already exists, then attempt to update
that lockfile without removing any prior package records.}

\item{force}{Boolean; force generation of a lockfile even when pre-flight
validation checks have failed?}

\item{reprex}{Boolean; generate output appropriate for embedding the lockfile
as part of a \href{https://www.tidyverse.org/help/#reprex}{reprex}?}
}
\value{
The generated lockfile, as an \R object (invisibly). Note that
this function is normally called for its side effects.
}
\description{
Call \code{snapshot()} to create a \strong{lockfile} capturing the state of a project's
\R package dependencies. The lockfile can be used to later restore these
project's dependencies as required.
}
\details{
See the \link{lockfile} documentation for more details on the structure of a
lockfile.
}
\section{Snapshot Type}{


Depending on how you prefer to manage dependencies, you might prefer
selecting a different snapshot mode. The modes available are as follows:

\describe{

\item{\code{"all"}}{
Capture all packages within the active \R libraries in the lockfile.
This is the quickest and simplest method, but may lead to undesired
packages (e.g. development dependencies) entering the lockfile.
}

\item{\code{"implicit"}}{
Only capture packages which appear to be used in your project in the
lockfile. The intersection of packages installed in your \R libraries,
alongside those used in your \R code as inferred by \code{renv::dependencies()},
will enter the lockfile. This helps ensure that only the packages your
project requires will enter the lockfile, but may be slower if your project
contains a large number of files. If this becomes an issue, you might
consider using \code{.renvignore} files to limit which files \code{renv} uses for
dependency discovery, or explicitly declaring your required dependencies in a
\code{DESCRIPTION} file. You can also force a dependency on a particular package
by writing e.g. \verb{library(<package>)} into a file called \code{dependencies.R}.
}

\item{\code{"explicit"}}{
Only capture packages which are explicitly listed in the project
\code{DESCRIPTION} file. This workflow is recommended for users who wish to
manage their project's \R package dependencies directly.
}

\item{\code{"custom"}}{
Like \code{"implicit"}, but use a custom user-defined filter instead. The filter
should be specified by the \R option \code{renv.snapshot.filter}, and should
either be a character vector naming a function (e.g. \code{"package::method"}),
or be a function itself. The function should only accept one argument (the
project directory), and should return a vector of package names to include
in the lockfile.
}

}

By default, \code{"implicit"}-style snapshots are used. The snapshot type can be
configured on a project-specific basis using the \code{renv} project \link{settings}
mechanism. For example, to use \code{"explicit"} snapshots in a project:

\if{html}{\out{<div class="sourceCode">}}\preformatted{renv::settings$snapshot.type("explicit")
}\if{html}{\out{</div>}}

When the \code{packages} argument is set, \code{type} is ignored, and instead only the
requested set of packages, and their recursive dependencies, will be written
to the lockfile.
}

\examples{

\dontrun{

# disable automatic snapshots
auto.snapshot <- getOption("renv.config.auto.snapshot")
options(renv.config.auto.snapshot = FALSE)

# initialize a new project (with an empty R library)
renv::init(bare = TRUE)

# install digest 0.6.19
renv::install("digest@0.6.19")

# save library state to lockfile
renv::snapshot()

# remove digest from library
renv::remove("digest")

# check library status
renv::status()

# restore lockfile, thereby reinstalling digest 0.6.19
renv::restore()

# restore automatic snapshots
options(renv.config.auto.snapshot = auto.snapshot)

}
}
\seealso{
Other reproducibility: 
\code{\link{lockfiles}},
\code{\link{restore}()}
}
\concept{reproducibility}
