% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/constructors.R
\name{create_ejAttribute}
\alias{create_ejAttribute}
\title{Create an attribute
This package outlines the aspects of the data for EpiJSON}
\usage{
create_ejAttribute(name, type, value, units = NA)
}
\arguments{
\item{name}{name of the attribute}

\item{type}{type of data 'string', 'number', 'integer', 'boolean', 'date' or
'base64'}

\item{value}{value of this attribute}

\item{units}{The units for value. May be omitted.}
}
\value{
an ejAttribute object
}
\description{
This function defines attributes
output \code{ejAttribute}
}
\examples{
characterAttribute <- create_ejAttribute(name="Format name", type="string",
	 value="EpiJSON!")
numericAttribute <- create_ejAttribute(name="Width of building", type="number",
	 value=5.2,"metres")
integerAttribute <- create_ejAttribute(name="Days since last accident", type="integer",
	 value=as.integer(2))
logicalAttribute <- create_ejAttribute(name="Customer satisfied", type="boolean",
	 value=TRUE)
dateAttributeOne <- create_ejAttribute(name="Birthdate", type="date",
	 value=as.Date("1998-08-21"))
dateAttributeTwo <- create_ejAttribute(name="Lunch", type="date",
	 value=as.POSIXct("2015-05-06 12:30"))
if (require(base64enc, quietly=TRUE)){
	binaryAttribute <- create_ejAttribute(name="Lunch", type="base64",
   value=base64encode(as.raw(0:255)))
}
}

