% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/repoS3.R
\name{repo_check}
\alias{repo_check}
\title{Check repo's integrity.}
\usage{
repo_check(repo)
}
\arguments{
\item{repo}{An object of class repo.}
}
\value{
Used for side effects.
}
\description{
Checks that all indexed files are present in the repository root
and that are not corrupt.
}
\details{
Every time the object associated to an item is stored, an
MD5 checksum is saved to the repository index. \code{check} will
use those to verify that the object did not change since the last
\code{put} or \code{set} on the item.
}
\examples{
repo_path <- file.path(tempdir(), "example_repo")
repo <- repo_open(repo_path, TRUE)
repo$put(0, "item1", "A sample item", "repo_check", replace=TRUE)
repo$check()

## wiping temporary repo
unlink(repo_path, TRUE)
}

