% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_parameters.R
\name{report_parameters}
\alias{report_parameters}
\title{Report the parameters of a model}
\usage{
report_parameters(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
A \code{vector}.
}
\description{
Creates a list containing a description of the parameters of R objects (see
list of supported objects in \code{\link{report}}).
}
\examples{
\donttest{
library(report)

# Miscellaneous
r <- report_parameters(sessionInfo())
r
summary(r)

# Data
report_parameters(iris$Sepal.Length)
report_parameters(as.character(round(iris$Sepal.Length, 1)))
report_parameters(iris$Species)
report_parameters(iris)

# h-tests
report_parameters(t.test(iris$Sepal.Width, iris$Sepal.Length))
report_parameters(cor.test(iris$Sepal.Width, iris$Sepal.Length))

# ANOVA
report_parameters(aov(Sepal.Length ~ Species, data = iris))

# GLMs
report_parameters(lm(Sepal.Length ~ Petal.Length * Species, data = iris))
report_parameters(lm(Petal.Width ~ Species, data = iris), include_intercept = FALSE)
report_parameters(glm(vs ~ disp, data = mtcars, family = "binomial"))

# Mixed models
if (require("lme4")) {
  model <- lme4::lmer(Sepal.Length ~ Petal.Length + (1 | Species), data = iris)
  report_parameters(model)
}

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(Sepal.Length ~ Species, data = iris, refresh = 0, iter = 600)
  report_parameters(model)
}
}
}
