% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_priors.R
\name{report_priors}
\alias{report_priors}
\title{Report priors of Bayesian models}
\usage{
report_priors(x, ...)
}
\arguments{
\item{x}{The R object that you want to report (see list of of supported
objects above).}

\item{...}{Arguments passed to or from other methods.}
}
\value{
An object of class \code{\link[=report_priors]{report_priors()}}.
}
\description{
Reports priors of Bayesian models (see list of supported objects in
\code{\link[=report]{report()}}).
}
\examples{
library(report)

# Bayesian models
if (require("rstanarm")) {
  model <- stan_glm(mpg ~ disp, data = mtcars, refresh = 0, iter = 1000)
  r <- report_priors(model)
  r
  summary(r)
}
}
