% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{nestTable}
\alias{nestTable}
\title{Combine two table columns into a single column with levels of one nested
within levels of the other.}
\usage{
nestTable(
  data,
  head_col,
  to_col,
  colHeader = "",
  caption = NULL,
  indent = TRUE,
  boldheaders = TRUE,
  hdr_prefix = "",
  hdr_suffix = "",
  digits = getOption("reportRmd.digits", 2),
  tableOnly = FALSE,
  fontsize
)
}
\arguments{
\item{data}{dataframe}

\item{head_col}{character value specifying the column name with the headers}

\item{to_col}{character value specifying the column name to add the headers
into}

\item{colHeader}{character with the desired name of the first column.
The default is to leave this empty for output or, for table only output to
use the column name 'col1'.}

\item{caption}{table caption}

\item{indent}{Boolean should the original values in the to_col be indented}

\item{boldheaders}{Boolean should the header column values be bolded}

\item{hdr_prefix}{character value that will prefix headers}

\item{hdr_suffix}{character value that will suffix headers}

\item{digits}{number of digits to round numeric columns to, wither a single
number or a vector corresponding to the number of numeric columns}

\item{tableOnly}{boolean indicating if the table should be formatted for
printing or returned as a data frame}

\item{fontsize}{PDF/HTML output only, manually set the table fontsize}
}
\value{
A character vector of the table source code, unless tableOnly=TRUE in
which case a data frame is returned
}
\description{
This function accepts a data frame (via the data argument) and combines two
columns into a single column with values from the head_col serving as headers
and values of the to_col displayed underneath each header. The resulting
table is then passed to outTable for printing and output, to use the grouped
table as a data frame specify tableOnly=TRUE. By default the headers will be
bolded and the remaining values indented.
}
\details{
Note that it is possible to combine multiple tables (more than two) with this
function.
}
\examples{
## Investigate models to predict baseline ctDNA and tumour size and display together
## (not clinically useful!)
data(pembrolizumab)
fit1 <- lm(baseline_ctdna~age+l_size+pdl1,data=pembrolizumab)
m1 <- rm_mvsum(fit1,tableOnly=TRUE)
m1$Response = 'ctDNA'
fit2 <- lm(l_size~age+baseline_ctdna+pdl1,data=pembrolizumab)
m2 <- rm_mvsum(fit2,tableOnly=TRUE)
m2$Response = 'Tumour Size'
nestTable(rbind(m1,m2),head_col='Response',to_col='Covariate')
}
