% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_spec.R
\name{lowcase_parens}
\alias{lowcase_parens}
\alias{upcase_parens}
\alias{lowcase_n}
\alias{upcase_n}
\title{Functions to format the population label}
\usage{
lowcase_parens(x)

upcase_parens(x)

lowcase_n(x)

upcase_n(x)
}
\arguments{
\item{x}{Population count}
}
\description{
These functions are used to format the "N=" population label
on column headers.
}
\details{
Which function to use to format the population label is specified
on the \code{n_format} parameter on the \code{\link{create_table}} function.
These formatting functions provide several options for formatting the "N=", 
including whether the "N" should be upper case or lower case, and whether
or not to put the value in parentheses.  If one of these options does not 
meet the specifications for your report, you may also write your own 
formatting function and pass it to the \code{n_format} function.  When an 
N value is supplied, the output of this function will be concatenated 
to the header label.
}
\examples{
# Create test data
l <- "Label"
n <- 47

cat(paste0(l, lowcase_parens(n)))
# Label
# (n=47)

cat(paste0(l, upcase_parens(n)))
# Label
# (N=47)

cat(paste0(l, lowcase_n(n)))
# Label
# n=47

cat(paste0(l, upcase_n(n)))
# Label
# N=47

customN <- function(n) {
  return(paste0(": N=", n))
}
cat(paste0(l, customN(n)))
# Label: N=47

}
\seealso{
\code{\link{create_table}} function to create a table.
}
