% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rPaperData.R
\docType{data}
\name{KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE}
\alias{KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE}
\title{KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE data illustrate correlations between
results from individual participants in a family of four cross-over experiments conducted by
Ricca et al.:
[1] F. Ricca, M. D. Penta, M. Torchiano, P. Tonella, and M. Ceccato "How developers’ experience
and ability influence web application comprehension tasks supported by uml stereotypes: A series
of four experiments", IEEE Transactions on Software Engineering, vol. 36, no. 1, pp. 96-118,
2010.
Although we present the full data set, only the first two experiments were used in the
correlation study, because many of the observations in the final two studies were unpaired.
The experiments assess whether participants performance comprehension tasks better when using
source code complemented by standard UML diagrams (UML) or by diagrams stereotyped using the
Conallen notation (Conallen).
If you use this data set please cite:
[1] F. Ricca, M. D. Penta, M. Torchiano, P. Tonella, and M. Ceccato "How developers’ experience
and ability influence web application comprehension tasks supported by uml stereotypes: A series
of four experiments", IEEE Transactions on Software Engineering, vol. 36, no. 1, pp. 96—118,
2010.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The Importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).}
\format{
A data frame with 176 rows and 10 variables:
\describe{
\item{ExperimentID}{<fct>|ExperimentID: A unique identifier for each of the four experiments in
the data set.}
\item{ParticipantID}{<fct>|Participant ID: An identifier for each participant, unique for a
specific experiment.}
\item{SequenceGroup}{<fct>|Experimental Sequence Group: A , B , C, D}
\item{System}{<fct>|Software systems used in the experiment: Two Java-based Web applications,
Claros and WfMS  }
\item{Period}{<fct>|Time period of the cross-over experiment: 1 or 2}
\item{Treatment}{<fct>|Experimental Treatment: UML or Conallon}
\item{FMeasure}{<dbl>|Dependent variable: The comprehension level achieved by the participant.}
\item{Time}{<dbl>|Dependent variable: The time [min] to complete the experimental task}
\item{CrossOverID}{<fct>|CrossOver category: For 4 group crossover designs, the crossover
category specifies the matching pairs of sequence groups, CO1 and CO2. For 2 group crossover,
the category is set to CO1 only}
\item{Ability}{<fct>| h: High l: Low, NA: Not available}
\item{Experience}{<fct>| G: Master students, U: undergraduates, P: researchers}
}
}
\usage{
KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE
}
\description{
KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE data illustrate correlations between
results from individual participants in a family of four cross-over experiments conducted by
Ricca et al.:
[1] F. Ricca, M. D. Penta, M. Torchiano, P. Tonella, and M. Ceccato "How developers’ experience
and ability influence web application comprehension tasks supported by uml stereotypes: A series
of four experiments", IEEE Transactions on Software Engineering, vol. 36, no. 1, pp. 96-118,
2010.
Although we present the full data set, only the first two experiments were used in the
correlation study, because many of the observations in the final two studies were unpaired.
The experiments assess whether participants performance comprehension tasks better when using
source code complemented by standard UML diagrams (UML) or by diagrams stereotyped using the
Conallen notation (Conallen).
If you use this data set please cite:
[1] F. Ricca, M. D. Penta, M. Torchiano, P. Tonella, and M. Ceccato "How developers’ experience
and ability influence web application comprehension tasks supported by uml stereotypes: A series
of four experiments", IEEE Transactions on Software Engineering, vol. 36, no. 1, pp. 96—118,
2010.
[2] Barbara Kitchenham, Lech Madeyski, Giuseppe Scanniello and Carmine Gravino, "The Importance
of the Correlation between Results from Individual Participants in Crossover Experiments"
(to be submitted as of 2020).
}
\examples{
KitchenhamEtAl.CorrelationsAmongParticipants.Ricca10TSE

}
\keyword{datasets}
