% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checksums.R
\docType{methods}
\name{Checksums}
\alias{Checksums}
\alias{Checksums,character,logical-method}
\alias{Checksums,character,missing-method}
\title{Calculate checksum}
\usage{
Checksums(path, write, quickCheck = FALSE, checksumFile = file.path(path,
  "CHECKSUMS.txt"), files = NULL, ...)

\S4method{Checksums}{character,logical}(path, write, quickCheck = FALSE,
  checksumFile = file.path(path, "CHECKSUMS.txt"), files = NULL, ...)

\S4method{Checksums}{character,missing}(path, write, quickCheck = FALSE,
  checksumFile = file.path(path, "CHECKSUMS.txt"), files = NULL, ...)
}
\arguments{
\item{path}{Character string giving the path to the module directory.}

\item{write}{Logical indicating whether to overwrite \code{CHECKSUMS.txt}.
Default is \code{FALSE}, as users should not change this file.
Module developers should write this file prior to distributing
their module code, and update accordingly when the data change.}

\item{quickCheck}{Logical. If \code{TRUE}, then this will only use file sizes,
rather than a digest::digest hash. This is generally faster,
but will be \emph{much} less robust.}

\item{checksumFile}{The filename of the checksums file to read or write to.
The default is \file{CHECKSUMS.txt} located at
\code{file.path(path, module, "data", checksumFile)}.
It is likely not a good idea to change this, and should
only be used in cases such as \code{Cache}, which can
evaluate if the \code{checksumFile} has changed.}

\item{files}{An optional character string or vector of specific files to checksum.
This may be very important if there are many files listed in a
\code{CHECKSUMS.txt} file, but only a few are to be checksummed.}

\item{...}{Passed to \code{\link[digest]{digest}} and \code{\link[utils]{write.table}}.
For \code{digest}, the notable argument is \code{algo}. For \code{write.table},
the notable argument is \code{append}.}
}
\value{
A \code{data.table} with columns: \code{result}, \code{expectedFile},
        \code{actualFile}, \code{checksum.x}, \code{checksum.y},
        \code{algorithm.x}, \code{algorithm.y}, \code{filesize.x}, \code{filesize.y}
        indicating the result of comparison between local file (\code{x}) and
        expectation based on the \code{CHECKSUMS.txt} file.
}
\description{
Verify (and optionally write) checksums.
Checksums are computed using \code{\link{.digest}}, which is simply a
wrapper around \code{digest::digest}.
}
\note{
In version 1.2.0 and earlier, two checksums per file were required
because of differences in the checksum hash values on Windows and Unix-like
platforms. Recent versions use a different (faster) algorithm and only require
one checksum value per file.
To update your \file{CHECKSUMS.txt} files using the new algorithm, see
\url{https://github.com/PredictiveEcology/SpaDES/issues/295#issuecomment-246513405}.
}
\examples{
\dontrun{
moduleName <- "my_module"
modulePath <- file.path("path", "to", "modules")

## verify checksums of all data files
Checksums(moduleName, modulePath)

## write new CHECKSUMS.txt file

# 1. verify that all data files are present (and no extra files are present)
list.files(file.path(modulePath, moduleName, "data"))

# 2. calculate file checksums and write to file (this will overwrite CHECKSUMS.txt)
Checksums(moduleName, modulePath, write = TRUE)
}

}
\author{
Alex Chubaty
}
