% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sry_yield.R
\name{yield}
\alias{yield}
\title{Storage-Reliability-Yield (SRY) relationships: Yield computation}
\usage{
yield(Q, capacity, reliability, profile = rep(1, frequency(Q)), plot = TRUE,
  S_initial = 1, max.iterations = 50, double_cycle = FALSE)
}
\arguments{
\item{Q}{a time series or vector  of net inflows to the reservoir.}

\item{capacity}{numerical.  (must be same volumetric unit as Q and R).}

\item{reliability}{numerical.  (must be same volumetric unit as Q and R).}

\item{profile}{a vector of factors with length = frequency(Q). Represents within-year demand profile. Defaults to constant release if left blank.}

\item{plot}{logical. If TRUE (the default) the storage behavior diagram and release time series are plotted.}

\item{S_initial}{numeric. The initial storage as a ratio of capacity (0 <= S_initial <= 1). The default value is 1.}

\item{max.iterations}{Maximum number of iterations for yield computation.}

\item{double_cycle}{logical. If TRUE the input series will be replicated and placed end-to-end to double the simulation. (Recommended if the critical period occurs at the end of the recorded inflow time series)}
}
\value{
Returns the storage behaviour time series for the no-failure (Rippl) reservoir given net inflows Q and target release R.
}
\description{
Returns the yield for given inflow time series, reservoir capacity, and required time-based reliability. Assumes standard operating policy. Yield is computed iteratively using the bi-section method.
}
\examples{
# Compute yield for 0.95 reliability
yield_ResX <- yield(ResX_inflow.ts, capacity = 100000, reliability = 0.95)
# Compute yield for quarterly time series with seasonal demand profile

quarterly.ts <- aggregate(ResX_inflow.ts, nfrequency = 4)
yield_ResX.quart <- yield(quarterly.ts,
capacity = 100000, reliability = 0.9, profile = c(0.8, 1.2, 1.2, 0.8))
}

