% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighted_stats.R
\name{weighted_moments}
\alias{weighted_moments}
\title{Compute weighted moments}
\usage{
weighted_moments(x, w, n = 2L, center = TRUE)
}
\arguments{
\item{x}{Observations}

\item{w}{Case weights (optional)}

\item{n}{Number of moments to calculate}

\item{center}{Calculate centralized moments (default) or noncentralized
moments, i.e. E((X - E(X))^k) or E(X^k).}
}
\value{
A vector of length \code{n} where the \code{k}th entry is the \code{k}th weighted
moment of \code{x} with weights \code{w}. If \code{center} is \code{TRUE} the moments are
centralized, i.e. E((X - E(X))^k). The first moment is never centralized.
The moments are scaled with 1 / sum(w), so they are not de-biased.

e.g. the second central weighted moment
\code{weighted_moment(x, w)[2L]}
is equal to
\code{var(rep(x, w)) * (sum(w) - 1) / sum(w)}
for integer \code{w}
}
\description{
Compute weighted moments
}
\examples{
weighted_moments(rexp(100))
weighted_moments(c(1, 2, 3), c(1, 2, 3))
c(mean(rep(1:3, 1:3)), var(rep(1:3, 1:3)) * 5 / 6)
}
\seealso{
Other weighted statistics: 
\code{\link{weighted_quantile}()},
\code{\link{weighted_tabulate}()}
}
\concept{weighted statistics}
