% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mine_gmatrix.R
\name{mine_gmatrix}
\alias{mine_gmatrix}
\title{Mine G-matrices}
\usage{
mine_gmatrix(
  loci = 18,
  layers = 6,
  indivs = 1000,
  npsize = 2000,
  mu_pr = 0.05,
  mu_sd = 0.01,
  max_gen = 1000,
  pr_cross = 0.05,
  sampleK = 40,
  chooseK = 4,
  term_cri = -5.3,
  sd_ini = 0.1,
  use_cor = FALSE,
  prnt_out = TRUE,
  gmatrix
)
}
\arguments{
\item{loci}{The number of loci that individuals in the model will have}

\item{layers}{The number of layers in the network from loci to traits}

\item{indivs}{The number of individuals to test the covariance matrix}

\item{npsize}{The size of the network population in the evolutionary algorithm}

\item{mu_pr}{The probability of a network value to mutate}

\item{mu_sd}{The standard deviation of mutation effect size}

\item{max_gen}{The maximum number of generations of the evolutionary algorithm}

\item{pr_cross}{The probability of a crossover occurring for a network}

\item{sampleK}{Number of networks sampled to take part in tournament selection}

\item{chooseK}{Number of winners in tournament selection}

\item{term_cri}{Stress criteria (ln) for evolutionary algorithm terminating}

\item{sd_ini}{StDev of initialised networked values}

\item{use_cor}{Compare correlation matrix rather than the covariance matrix}

\item{prnt_out}{Print out progress showing stress for each generation}

\item{gmatrix}{G-matrix that the evolutionary algorithm will match}
}
\value{
A list of eight elements that includes the following: (1) A vector of
input parameters, (2) the pre-specified covariance matrix, (3) matrix defining
the effects of loci values on the first layer of the network, (4) a three
dimensional array link the first network layer to trait values, (5) a matrix
of the marginal effect of each locus on each trait, (6) the mined covariance
structure, (7) all network values to be inserted into individual genomes, and
(8) the log stress of the mined matrix against the pre-specified matrix.
}
\description{
Mine networks for establishing the link between genome and g-matrix. The 
output from this function is required to run individual-based simulations
in the rest of the package. The key input to this function, 'gmatrix', is a
(square) covariance matrix, with each row and column representing a trait for
the individual-based model. This function will run an evolutionary algorithm
to try to find a network that produces traits with the covariance structure
of gmatrix from a set of random standard normal values. The network from loci
values to trait values goes through a number of linked nodes to achieve this, 
and each generation tests the stress of the resulting network in terms of 
expected squared deviation of trait covariances from the input gmatrix. 
Simulations can take minutes to hours or longer, depending on parameters 
chosen and the number of traits. See vignettes for a more comprehensive
explanation for what this function is doing.
}
\examples{
gmt       <- matrix(data = 0, nrow = 4, ncol = 4);
diag(gmt) <- 1;
mg        <- mine_gmatrix(gmatrix = gmt, loci = 4, layers = 3, indivs = 100, 
                         npsize = 100, max_gen = 2, prnt_out = FALSE);
}
