% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ResourceClient.R
\name{newResourceClient}
\alias{newResourceClient}
\title{Creates a resource client}
\usage{
newResourceClient(x)
}
\arguments{
\item{x}{The resource object which corresponding resolver is to be found.}
}
\value{
The corresponding ResourceClient object or NULL if none applies.
}
\description{
From a resource object, find the corresponding resolver in the resolver registry
and create a new resource client.
}
\examples{
\donttest{
library(resourcer)
res <- newResource(
  name = "CNSIM1",
  url = "file:///data/CNSIM1.sav",
  format = "spss"
)
client <- newResourceClient(res)
}

}
