/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.util.objects.tree;

public interface Interval
extends Comparable<Interval> {
    public int start();

    public int end();

    default public int length() {
        return this.end() - this.start();
    }

    default public boolean isAdjacent(Interval other) {
        return this.start() == other.end() || this.end() == other.start();
    }

    default public boolean overlaps(Interval o) {
        return this.end() > o.start() && o.end() > this.start();
    }

    default public boolean overlaps(int start, int end) {
        return this.end() > start && end > this.start();
    }

    @Override
    default public int compareTo(Interval o) {
        return this.compareTo(o.start(), o.end());
    }

    default public int compareTo(int s, int e) {
        int d = this.start() - s;
        if (!(1.$assertionsDisabled || this.start() > s && d > 0 || this.start() < s && d < 0 || this.start() == s && d == 0)) {
            throw new AssertionError();
        }
        if (d == 0) {
            d = this.end() - e;
            if (!(1.$assertionsDisabled || this.end() > e && d > 0 || this.end() < e && d < 0 || this.end() == e && d == 0)) {
                throw new AssertionError();
            }
        }
        return Integer.signum(d);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

