/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.real;

import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.constraints.real.IbexHandler;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.events.RealEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.tools.VariableUtils;

public class RealPropagator
extends Propagator<Variable> {
    private final IbexHandler ibex;
    protected final String functions;
    BoolVar reified;

    public RealPropagator(String functions, Variable[] vars) {
        super(vars, (Priority)PropagatorPriority.LINEAR, false);
        this.ibex = this.model.getIbexHandler();
        this.functions = functions;
        this.ibex.declare(this);
    }

    protected void reify(BoolVar r) {
        this.addVariable(new Variable[]{r});
        this.reified = r;
    }

    @Override
    public int getPropagationConditions(int vIdx) {
        if (VariableUtils.isReal(this.vars[vIdx])) {
            return RealEventType.BOUND.getMask();
        }
        return IntEventType.boundAndInst();
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.ibex.contract(this);
    }

    @Override
    public ESat isEntailed() {
        return ESat.TRUE;
    }

    public void setContractionRatio(double ratio) {
        this.ibex.setContractionRatio(ratio);
    }

    public double getContractionRatio() {
        return this.ibex.getContractionRatio();
    }

    @Override
    public String toString() {
        return super.toString() + " ->(\"" + this.functions + "\")";
    }
}

