/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.impl;

import java.util.Iterator;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Model;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IVariableMonitor;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.impl.AbstractVariable;
import org.chocosolver.solver.variables.impl.scheduler.IntEvtScheduler;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.solver.variables.view.IView;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.EvtScheduler;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public class FixedIntVarImpl
extends AbstractVariable
implements IntVar {
    protected final int constante;
    private DisposableValueIterator _viterator;
    private DisposableRangeIterator _riterator;
    private final IntVarValueIterator _javaIterator = new IntVarValueIterator(this);
    protected SignedLiteral literal;

    public FixedIntVarImpl(String name, int constante, Model model) {
        super(name, model);
        this.constante = constante;
    }

    @Override
    public boolean removeValue(int value, ICause cause) throws ContradictionException {
        if (value == this.constante) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().removeValue(this, this.constante, cause);
            this.contradiction(cause, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        if (values.contains(this.constante)) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().removeValue(this, this.constante, cause);
            this.contradiction(cause, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        if (!values.contains(this.constante)) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().removeValue(this, this.constante, cause);
            this.contradiction(cause, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        if (from <= this.constante && this.constante <= to) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().removeValue(this, this.constante, cause);
            this.contradiction(cause, "unique value removal");
        }
        return false;
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        if (value != this.constante) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.constante, this.constante);
            this.contradiction(cause, "outside domain instantitation");
        }
        return false;
    }

    @Override
    public boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        if (value > this.constante) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().updateLowerBound(this, value, this.constante, cause);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        if (value < this.constante) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().updateUpperBound(this, value, this.constante, cause);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        if (lb > this.constante) {
            assert (cause != null);
            this.model.getSolver().getEventObserver().updateLowerBound(this, lb, this.constante, cause);
            this.contradiction(cause, "outside domain update bound");
        } else if (ub < this.constante) {
            this.model.getSolver().getEventObserver().updateUpperBound(this, ub, this.constante, cause);
            this.contradiction(cause, "outside domain update bound");
        }
        return false;
    }

    @Override
    public boolean contains(int value) {
        return this.constante == value;
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        return this.constante == value;
    }

    @Override
    public int getValue() {
        return this.constante;
    }

    @Override
    public int getLB() {
        return this.constante;
    }

    @Override
    public int getUB() {
        return this.constante;
    }

    @Override
    public int getDomainSize() {
        return 1;
    }

    @Override
    public int getRange() {
        return 1;
    }

    @Override
    public int nextValue(int v) {
        if (v < this.constante) {
            return this.constante;
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int nextValueOut(int v) {
        if (v == this.constante - 1) {
            return this.constante + 1;
        }
        return v + 1;
    }

    @Override
    public int previousValue(int v) {
        if (v > this.constante) {
            return this.constante;
        }
        return Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int v) {
        if (v == this.constante + 1) {
            return this.constante - 1;
        }
        return v - 1;
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return true;
    }

    @Override
    public NoDelta getDelta() {
        return NoDelta.singleton;
    }

    @Override
    public boolean isInstantiated() {
        return true;
    }

    public void addMonitor(IVariableMonitor monitor) {
    }

    public void removeMonitor(IVariableMonitor monitor) {
    }

    public void subscribeView(IView view, int idx) {
    }

    @Override
    public IIntDeltaMonitor monitorDelta(ICause propagator) {
        return IIntDeltaMonitor.Default.NONE;
    }

    @Override
    public void createDelta() {
    }

    @Override
    public void notifyPropagators(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public void notifyMonitors(IEventType event) throws ContradictionException {
    }

    @Override
    public void notifyViews(IEventType event, ICause cause) throws ContradictionException {
    }

    @Override
    public String toString() {
        return this.name + " = " + this.constante;
    }

    @Override
    public int getTypeAndKind() {
        return 10;
    }

    protected EvtScheduler createScheduler() {
        return new IntEvtScheduler();
    }

    @Override
    public DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueIterator(){
                boolean _next;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this._next = true;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this._next = true;
                }

                @Override
                public boolean hasNext() {
                    return this._next;
                }

                @Override
                public boolean hasPrevious() {
                    return this._next;
                }

                @Override
                public int next() {
                    this._next = false;
                    return FixedIntVarImpl.this.constante;
                }

                @Override
                public int previous() {
                    this._next = false;
                    return FixedIntVarImpl.this.constante;
                }
            };
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeIterator(){
                boolean _next;

                @Override
                public void bottomUpInit() {
                    super.bottomUpInit();
                    this._next = true;
                }

                @Override
                public void topDownInit() {
                    super.topDownInit();
                    this._next = true;
                }

                @Override
                public boolean hasNext() {
                    return this._next;
                }

                @Override
                public boolean hasPrevious() {
                    return this._next;
                }

                @Override
                public void next() {
                    this._next = false;
                }

                @Override
                public void previous() {
                    this._next = false;
                }

                @Override
                public int min() {
                    return FixedIntVarImpl.this.constante;
                }

                @Override
                public int max() {
                    return FixedIntVarImpl.this.constante;
                }
            };
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Set(rootDomain);
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }
}

