/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.loop.move;

import java.util.Collections;
import java.util.List;
import org.chocosolver.cutoffseq.ICutoffStrategy;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.loop.move.Move;
import org.chocosolver.solver.search.strategy.strategy.AbstractStrategy;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.util.criteria.LongCriterion;

public class MoveRestart
implements Move {
    private Move move;
    private final ICutoffStrategy restartStrategy;
    private final LongCriterion criterion;
    private int restartFromStrategyCount;
    private final int restartLimit;
    private long limit;
    protected long solutions;
    private final boolean resetCutoffOnSolution;

    public MoveRestart(Move move, ICutoffStrategy restartStrategy, LongCriterion criterion, int restartLimit, boolean resetCutoffOnSolution) {
        this.move = move;
        this.restartStrategy = restartStrategy;
        this.criterion = criterion;
        this.restartLimit = restartLimit;
        this.resetCutoffOnSolution = resetCutoffOnSolution;
    }

    @Override
    public boolean init() {
        this.restartFromStrategyCount = 0;
        this.limit = this.restartStrategy.getNextCutoff();
        return this.move.init();
    }

    @Override
    public boolean extend(Solver solver) {
        boolean extend;
        if (!this.criterion.isMet(this.limit)) {
            extend = this.move.extend(solver);
        } else {
            this.restart(solver);
            extend = true;
        }
        return extend;
    }

    @Override
    public boolean repair(Solver solver) {
        boolean repair;
        if (this.resetCutoffOnSolution && this.solutions < solver.getSolutionCount()) {
            this.solutions = solver.getSolutionCount();
            this.restartStrategy.reset();
        }
        if (!this.criterion.isMet(this.limit)) {
            repair = this.move.repair(solver);
        } else {
            this.restart(solver);
            repair = true;
        }
        return repair;
    }

    @Override
    public void setTopDecisionPosition(int position) {
        this.move.setTopDecisionPosition(position);
    }

    @Override
    public <V extends Variable> AbstractStrategy<V> getStrategy() {
        return this.move.getStrategy();
    }

    @Override
    public <V extends Variable> void setStrategy(AbstractStrategy<V> aStrategy) {
        this.move.setStrategy(aStrategy);
    }

    @Override
    public void removeStrategy() {
        this.move.removeStrategy();
    }

    protected void restart(Solver solver) {
        ++this.restartFromStrategyCount;
        if (this.restartFromStrategyCount >= this.restartLimit) {
            this.limit = Long.MAX_VALUE;
        } else if (this.criterion.isMet(this.limit)) {
            this.limit += this.restartStrategy.getNextCutoff();
        }
        solver.restart();
    }

    @Override
    public List<Move> getChildMoves() {
        return Collections.singletonList(this.move);
    }

    @Override
    public void setChildMoves(List<Move> someMoves) {
        if (someMoves.size() != 1) {
            throw new UnsupportedOperationException("Only one child move can be attached to it.");
        }
        this.move = someMoves.get(0);
    }
}

