/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.variables.view.bool;

import java.util.Iterator;
import org.chocosolver.memory.IStateBool;
import org.chocosolver.solver.ICause;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.learn.ExplanationForSignedClause;
import org.chocosolver.solver.variables.BoolVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IDelta;
import org.chocosolver.solver.variables.delta.IEnumDelta;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.NoDelta;
import org.chocosolver.solver.variables.delta.monitor.OneValueDeltaMonitor;
import org.chocosolver.solver.variables.events.IEventType;
import org.chocosolver.solver.variables.events.IntEventType;
import org.chocosolver.solver.variables.impl.scheduler.BoolEvtScheduler;
import org.chocosolver.solver.variables.impl.siglit.SignedLiteral;
import org.chocosolver.solver.variables.view.AbstractView;
import org.chocosolver.util.ESat;
import org.chocosolver.util.iterators.DisposableRangeBoundIterator;
import org.chocosolver.util.iterators.DisposableRangeIterator;
import org.chocosolver.util.iterators.DisposableValueBoundIterator;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.iterators.IntVarValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableRangeSet;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableSet;

public class BoolSetView<S extends SetVar>
extends AbstractView<S>
implements BoolVar {
    protected S setVar;
    protected int v;
    protected IEnumDelta delta = NoDelta.singleton;
    protected boolean reactOnRemoval = false;
    protected IStateBool fixed;
    private BoolVar not;
    private boolean isNot = false;
    protected DisposableValueIterator _viterator;
    protected DisposableRangeIterator _riterator;
    private final IntVarValueIterator _javaIterator = new IntVarValueIterator(this);
    protected SignedLiteral literal;

    public BoolSetView(int v, S setVar) {
        super("boolSetView[" + v + " in " + setVar.getName() + "]", (Variable[])new SetVar[]{setVar});
        this.setVar = setVar;
        this.v = v;
        boolean initialValue = setVar.getLB().contains(v) || !setVar.getUB().contains(v);
        this.fixed = this.getModel().getEnvironment().makeBool(initialValue);
    }

    @Override
    public ESat getBooleanValue() {
        if (this.setVar.getLB().contains(this.v)) {
            return ESat.TRUE;
        }
        if (!this.setVar.getUB().contains(this.v)) {
            return ESat.FALSE;
        }
        return ESat.UNDEFINED;
    }

    @Override
    public void notify(IEventType event, int variableIdx) throws ContradictionException {
        if (!this.fixed.get() && this.isInstantiated()) {
            this.fixed.set(true);
            this.notifyPropagators(event, this);
        }
    }

    @Override
    public boolean setToTrue(ICause cause) throws ContradictionException {
        return this.instantiateTo(1, cause);
    }

    @Override
    public boolean setToFalse(ICause cause) throws ContradictionException {
        return this.instantiateTo(0, cause);
    }

    @Override
    public boolean instantiateTo(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        boolean done = false;
        if (!this.contains(value)) {
            this.model.getSolver().getEventObserver().instantiateTo(this, this.v, cause, this.getLB(), this.getUB());
            this.contradiction(cause, "empty domain");
        } else if (!this.isInstantiated()) {
            this.model.getSolver().getEventObserver().instantiateTo(this, value, cause, this.getLB(), this.getUB());
            this.fixed.set(true);
            if (this.reactOnRemoval) {
                this.delta.add(1 - value, cause);
            }
            done = value == 1 ? this.setVar.force(this.v, this) : this.setVar.remove(this.v, this);
            this.notifyPropagators(IntEventType.INSTANTIATE, cause);
        }
        return done;
    }

    @Override
    public boolean contains(int value) {
        if (value == 0) {
            return !this.setVar.getLB().contains(this.v);
        }
        if (value == 1) {
            return this.setVar.getUB().contains(this.v);
        }
        return false;
    }

    @Override
    public boolean isInstantiated() {
        if (this.setVar.getLB().contains(this.v)) {
            return true;
        }
        return !this.setVar.getUB().contains(this.v);
    }

    @Override
    public boolean isInstantiatedTo(int value) {
        if (value == 0) {
            return !this.setVar.getUB().contains(this.v);
        }
        if (value == 1) {
            return this.setVar.getLB().contains(this.v);
        }
        return false;
    }

    @Override
    public int getDomainSize() {
        return this.isInstantiated() ? 1 : 2;
    }

    @Override
    public int getRange() {
        return this.getUB() - this.getLB();
    }

    @Override
    public boolean hasEnumeratedDomain() {
        return false;
    }

    @Override
    public int getLB() {
        if (this.setVar.getLB().contains(this.v)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getUB() {
        if (this.setVar.getUB().contains(this.v)) {
            return 1;
        }
        return 0;
    }

    @Override
    public int nextValue(int val) {
        if (val < 0 && this.contains(0)) {
            return 0;
        }
        return val <= 0 && this.contains(1) ? 1 : Integer.MAX_VALUE;
    }

    @Override
    public final int getTypeAndKind() {
        return 28;
    }

    @Override
    public final int getValue() {
        return this.getLB();
    }

    protected final BoolEvtScheduler createScheduler() {
        return new BoolEvtScheduler();
    }

    @Override
    public IDelta getDelta() {
        return this.delta;
    }

    @Override
    public void createDelta() {
        this.setVar.createDelta();
    }

    @Override
    public final IIntDeltaMonitor monitorDelta(ICause propagator) {
        this.createDelta();
        return new OneValueDeltaMonitor(this.delta, propagator);
    }

    @Override
    public final void _setNot(BoolVar neg) {
        this.not = neg;
    }

    @Override
    public final BoolVar not() {
        if (!this.hasNot()) {
            this.not = this.model.boolNotView(this);
            this.not._setNot(this);
        }
        return this.not;
    }

    @Override
    public final boolean hasNot() {
        return this.not != null;
    }

    @Override
    public final boolean isLit() {
        return true;
    }

    @Override
    public final boolean isNot() {
        return this.isNot;
    }

    @Override
    public final void setNot(boolean isNot) {
        this.isNot = isNot;
    }

    @Override
    public int nextValueOut(int val) {
        int lb = this.getLB();
        int ub = this.getUB();
        if (lb - 1 <= val && val <= ub) {
            return ub + 1;
        }
        return val + 1;
    }

    @Override
    public int previousValue(int val) {
        if (val > 1 && this.contains(1)) {
            return 1;
        }
        return val >= 1 && this.contains(0) ? 0 : Integer.MIN_VALUE;
    }

    @Override
    public int previousValueOut(int val) {
        int lb = this.getLB();
        int ub = this.getUB();
        if (lb <= val && val <= ub + 1) {
            return lb - 1;
        }
        return val - 1;
    }

    @Override
    public final boolean removeValue(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        if (value == 0) {
            return this.instantiateTo(1, cause);
        }
        if (value == 1) {
            return this.instantiateTo(0, cause);
        }
        return false;
    }

    @Override
    public final boolean removeValues(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final boolean removeAllValuesBut(IntIterableSet values, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (!values.contains(0)) {
            hasChanged = this.instantiateTo(1, cause);
        }
        if (!values.contains(1)) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final boolean removeInterval(int from, int to, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (from <= to && from <= 1 && to >= 0) {
            if (from == 1) {
                hasChanged = this.instantiateTo(0, cause);
            } else if (to == 0) {
                hasChanged = this.instantiateTo(1, cause);
            } else {
                this.model.getSolver().getEventObserver().instantiateTo(this, 2, cause, 0, 1);
                this.contradiction(cause, "empty domain");
            }
        }
        return hasChanged;
    }

    @Override
    public final boolean updateLowerBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value > 0 && this.instantiateTo(value, cause);
    }

    @Override
    public final boolean updateUpperBound(int value, ICause cause) throws ContradictionException {
        assert (cause != null);
        return value < 1 && this.instantiateTo(value, cause);
    }

    @Override
    public final boolean updateBounds(int lb, int ub, ICause cause) throws ContradictionException {
        boolean hasChanged = false;
        if (lb > 1 || ub < 0) {
            this.model.getSolver().getEventObserver().instantiateTo(this, 2, cause, 0, 1);
            this.contradiction(cause, "empty domain");
        } else if (lb == 1) {
            hasChanged = this.instantiateTo(1, cause);
        } else if (ub == 0) {
            hasChanged = this.instantiateTo(0, cause);
        }
        return hasChanged;
    }

    @Override
    public final DisposableValueIterator getValueIterator(boolean bottomUp) {
        if (this._viterator == null || this._viterator.isNotReusable()) {
            this._viterator = new DisposableValueBoundIterator(this);
        }
        if (bottomUp) {
            this._viterator.bottomUpInit();
        } else {
            this._viterator.topDownInit();
        }
        return this._viterator;
    }

    @Override
    public final DisposableRangeIterator getRangeIterator(boolean bottomUp) {
        if (this._riterator == null || this._riterator.isNotReusable()) {
            this._riterator = new DisposableRangeBoundIterator(this);
        }
        if (bottomUp) {
            this._riterator.bottomUpInit();
        } else {
            this._riterator.topDownInit();
        }
        return this._riterator;
    }

    @Override
    public Iterator<Integer> iterator() {
        this._javaIterator.reset();
        return this._javaIterator;
    }

    @Override
    public void createLit(IntIterableRangeSet rootDomain) {
        if (this.literal != null) {
            throw new IllegalStateException("createLit(Implications) called twice");
        }
        this.literal = new SignedLiteral.Boolean();
    }

    @Override
    public SignedLiteral getLit() {
        if (this.literal == null) {
            throw new NullPointerException("getLit() called on null, a call to createLit(Implications) is required");
        }
        return this.literal;
    }

    @Override
    public void justifyEvent(IntEventType mask, int one, int two, int three) {
        throw new UnsupportedOperationException("Bool view over set variables does not support explanations");
    }

    @Override
    public void explain(int p, ExplanationForSignedClause explanation) {
        throw new UnsupportedOperationException("Bool view over set variables does not support explanations");
    }
}

