% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{preprocess_input}
\alias{preprocess_input}
\title{Restopr input preprocessing function.}
\usage{
preprocess_input(habitat, habitat_threshold = 1, aggregation_factor = 1)
}
\arguments{
\item{habitat}{\code{\link[terra:rast]{terra::rast()}} Raster object containing binary
values that indicate if each planning unit contains habitat or not. Cells
with the value \code{1} must correspond to existing habitat. Cells with the value
\code{0} must correspond to degraded (or simply non-habitat) areas. Finally,
\code{NA} (or \code{NO_DATA}) cells are considered to be outside of the landscape.}

\item{habitat_threshold}{\code{numeric} Number between 0 and 1 indicating, when the habitat
raster is downsampled, the minimum proportion of habitat cells (from the
original raster) are required within the downsampled raster to be considered
as habitat.}

\item{aggregation_factor}{\code{integer} positive integer corresponding to the level of
downsampling that will be applied to the habitat. This parameter is
important to ensure the tractability of a problem.}
}
\value{
A list : list(
existing_habitat=downsampled_habitat,
restorable_habitat=restorable_habitat,
cell_area=cell_area
)
}
\description{
From a binary, possibly high resolution, habitat raster, this function
produces three input rasters for restopt:
}
\details{
\itemize{
\item The binary habitat raster (existing_habitat), which can be the same as
the input (aggregation factor = 1), but most often is a downsampled
version of it, to ensure the tractability of the problem.
\item The restorable habitat raster (restorable_habitat), which is a raster
indicating how much habitat can be restored. If the aggregation factor = 1,
the the restorable habitat raster is binary and the inverse of the habitat
raster. Else, the surface of habitat is computed according to the spatial
resolution, and the number of habitat pixel present in one larger
aggregated cell.
\item The cell area raster (cell_area), which correspond for each aggregated
cell to the number of number of cells in the input raster. This is
necessary because the cell area can be less than expected if the
aggregated cell lies in the boundary of study area.
}

This preprocessing function produces the necessary inputs of a
restopt problem from a single binary habitat raster (\code{habitat}), which can
be at high resolution. Restopt solves a hard constrained combinatorial problem
(it can be reduced to a constrained 0/1 knapsack problem, which is know to
be NP-Complete), thus the input resolution might need to be reduced to
ensure a tractable problem. Performing this downsampling in a systematic
and reproducible way is the aim of this function, which relies on the
\code{terra::aggregate()} function to do it. The \code{aggregation_factor} parameter
indicates how much the resolution must be reduced. An aggregated pixel
will contain at most \code{aggregation_factor^2} pixels from the input \code{habitat}
raster (\code{cell_area} raster in this function outputs). If an aggregated pixel
is close to the spatial boundaries of the problem (i.e. NA cells), it can
contain less than \code{aggregation_factor^2} fine grained pixels. The
\code{habitat_threshold} parameter indicates the minimum proportion of \code{habitat}
pixels (relative to \code{cell_area}) whose value is 1 to consider an aggregated
pixel as habitat (\code{downsampled_habitat} output raster). The \code{restorable_area}
output raster correspond to the number of pixel with value 0 in aggregated pixels.
}
\examples{
\donttest{
# load data
habitat_data <- rast(
  system.file("extdata", "habitat_hi_res.tif", package = "restoptr"))
data <- preprocess_input(
    habitat = habitat_data,
    habitat_threshold = 0.7,
    aggregation_factor = 16
)
}

}
