% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/univariateDivision.R
\name{univariateDivision}
\alias{univariateDivision}
\title{Division of univariate polynomials}
\usage{
univariateDivision(qspray1, qspray2)
}
\arguments{
\item{qspray1, qspray2}{two univariate \code{qspray} polynomials}
}
\value{
A list of two univariate \code{qspray} polynomials, the quotient
  of the division in the field \code{Q} of the list, and the remainder in
  the field \code{R}.
}
\description{
Division with remainder of univariate polynomials with rational
  coefficients.
}
\examples{
library(resultant)
x <- qlone(1)
qspray1 <- 2*x^4 + x^3 - 3*x^2 - x + 1
qspray2 <- x^2 - 5*x + 10
division <- univariateDivision(qspray1, qspray2)
Q <- division[["Q"]]; R <- division[["R"]]
qspray1 == Q*qspray2 + R # should be TRUE
}
\seealso{
\code{\link{integralDivision}},
  \code{\link[qspray]{qsprayDivision}}.
}
