% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/python.R
\name{==.python.builtin.object}
\alias{==.python.builtin.object}
\alias{!=.python.builtin.object}
\alias{<.python.builtin.object}
\alias{>.python.builtin.object}
\alias{>=.python.builtin.object}
\alias{<=.python.builtin.object}
\alias{+.python.builtin.object}
\alias{-.python.builtin.object}
\alias{*.python.builtin.object}
\alias{/.python.builtin.object}
\alias{\%/\%.python.builtin.object}
\alias{\%\%.python.builtin.object}
\alias{^.python.builtin.object}
\alias{&.python.builtin.object}
\alias{|.python.builtin.object}
\alias{!.python.builtin.object}
\alias{\%*\%.python.builtin.object}
\title{S3 Ops Methods for Python Objects}
\usage{
\method{==}{python.builtin.object}(e1, e2)

\method{!=}{python.builtin.object}(e1, e2)

\method{<}{python.builtin.object}(e1, e2)

\method{>}{python.builtin.object}(e1, e2)

\method{>=}{python.builtin.object}(e1, e2)

\method{<=}{python.builtin.object}(e1, e2)

\method{+}{python.builtin.object}(e1, e2)

\method{-}{python.builtin.object}(e1, e2)

\method{*}{python.builtin.object}(e1, e2)

\method{/}{python.builtin.object}(e1, e2)

\method{\%/\%}{python.builtin.object}(e1, e2)

\method{\%\%}{python.builtin.object}(e1, e2)

\method{^}{python.builtin.object}(e1, e2)

\method{&}{python.builtin.object}(e1, e2)

\method{|}{python.builtin.object}(e1, e2)

\method{!}{python.builtin.object}(e1)

\method{\%*\%}{python.builtin.object}(x, y)
}
\arguments{
\item{e1, e2, x, y}{A python object.}
}
\value{
Result from evaluating the Python expression. If either of the
arguments to the operator was a Python object with \code{convert=FALSE}, then
the result will also be a Python object with \code{convert=FALSE} set.
Otherwise, the result will be converted to an R object if possible.
}
\description{
Reticulate provides S3 Ops Group Generic Methods for Python objects. The methods
invoke the equivalent python method of the object.
}
\section{Operator Mappings}{
\tabular{lll}{
   R expression \tab Python expression \tab First python method invoked \cr
   \code{x == y} \tab \code{x == y} \tab \verb{type(x).__eq__(x, y)} \cr
   \code{x != y} \tab \code{x != y} \tab \verb{type(x).__ne__(x, y)} \cr
   \code{x < y} \tab \code{x < y} \tab \verb{type(x).__lt__(x, y)} \cr
   \code{x > y} \tab \code{x > y} \tab \verb{type(x).__gt__(x, y)} \cr
   \code{x >= y} \tab \code{x >= y} \tab \verb{type(x).__ge__(x, y)} \cr
   \code{x <= y} \tab \code{x <= y} \tab \verb{type(x).__le__(x, y)} \cr
   \code{+ x } \tab \code{+ x} \tab \verb{type(x).__pos__(x)} \cr
   \code{- y} \tab \code{- x} \tab \verb{type(x).__neg__(x)} \cr
   \code{x + y} \tab \code{x + y} \tab \verb{type(x).__add__(x, y)} \cr
   \code{x - y} \tab \code{x - y} \tab \verb{type(x).__sub__(x, y)} \cr
   \code{x * y} \tab \code{x * y} \tab \verb{type(x).__mul__(x, y)} \cr
   \code{x / y} \tab \code{x / y} \tab \verb{type(x).__truediv__(x, y)} \cr
   \code{x \%/\% y} \tab \verb{x // y} \tab \verb{type(x).__floordiv__(x, y)} \cr
   \code{x \%\% y} \tab \verb{x \% y} \tab \verb{type(x).__mod__(x, y)} \cr
   \code{x ^ y} \tab \code{x ** y} \tab \verb{type(x).__pow__(x, y)} \cr
   \code{x & y} \tab \code{x & y} \tab \verb{type(x).__and__(x, y)} \cr
   \code{x | y} \tab \code{x | y} \tab \verb{type(x).__or__(x, y)} \cr
   \code{!x} \tab \code{~x} \tab \verb{type(x).__not__(x)} \cr
   \code{x \%*\% y} \tab \code{x @ y} \tab \verb{type(x).__matmul__(x, y)} \cr
}


Note: If the initial Python method invoked raises a \code{NotImplemented}
Exception, the Python interpreter will attempt to use the reflected
variant of the method from the second argument. The arithmetic operators
will call the equivalent double underscore (dunder) method with an "r" prefix. For
instance, when evaluating the expression \code{x + y}, if \verb{type(x).__add__(x, y)}
raises a \code{NotImplemented} exception, then the interpreter will attempt
\verb{type(y).__radd__(y, x)}. The comparison operators follow a different
sequence of fallbacks; refer to the Python documentation for more details.
}

