% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{py_requirements_files}
\alias{py_requirements_files}
\alias{py_write_requirements}
\alias{py_read_requirements}
\title{Write and read Python requirements files}
\usage{
py_write_requirements(
  packages = "requirements.txt",
  python_version = ".python-version",
  ...,
  freeze = NULL,
  python = py_exe(),
  quiet = FALSE
)

py_read_requirements(
  packages = "requirements.txt",
  python_version = ".python-version",
  ...,
  action = c("add", "set", "remove", "none")
)
}
\arguments{
\item{packages}{Path to the package requirements file. Defaults to
\code{"requirements.txt"}. Use \code{NULL} to skip.}

\item{python_version}{Path to the Python version file. Defaults to
\code{".python-version"}. Use \code{NULL} to skip.}

\item{...}{Unused; must be empty.}

\item{freeze}{Logical. If \code{TRUE}, writes a fully resolved list of
installed packages using \verb{pip freeze}. If \code{FALSE}, writes only the
requirements tracked by \code{\link[=py_require]{py_require()}}.}

\item{python}{Path to the Python executable to use.}

\item{quiet}{Logical; if \code{TRUE}, suppresses the informational messages
that print \verb{wrote '<path>'} for each file written.}

\item{action}{How to apply requirements read by \code{py_read_requirements()}:
\code{"add"} (default) adds to existing requirements, \code{"set"} replaces them,
\code{"remove"} removes matching entries, or \code{"none"} skips applying them
and returns the read values.}
}
\value{
Invisibly, a list with two named elements:
\describe{
\item{\code{packages}}{Character vector of package requirements.}
\item{\code{python_version}}{String specifying the Python version.}
}

To get just the return value without writing any files, you can pass
\code{NULL} for file paths, like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{py_write_requirements(NULL, NULL)
py_write_requirements(NULL, NULL, freeze = TRUE)
}\if{html}{\out{</div>}}
}
\description{
\itemize{
\item \code{py_write_requirements()} writes the requirements currently tracked by
\code{\link[=py_require]{py_require()}}. If \code{freeze = TRUE} or if the \code{python} environment is not
ephemeral, it writes a fully resolved manifest via \verb{pip freeze}.
\item \code{py_read_requirements()} reads \code{requirements.txt} and \code{.python-version}, and
applies them with \code{\link[=py_require]{py_require()}}. By default, entries are added (\code{action = "add"}).
}

These are primarily an alternative interface to \code{py_require()}, but can
also work with non-ephemeral virtual environments.
}
\note{
To continue using \code{py_require()} locally while keeping a
\code{requirements.txt} up-to-date for deployments, you can register
an exit handler in \code{.Rprofile} like this:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{reg.finalizer(
  asNamespace("reticulate"),
  function(ns) \{
    if (
      reticulate::py_available() &&
        isTRUE(reticulate::py_config()$ephemeral)
    ) \{
      reticulate::py_write_requirements(quiet = TRUE)
    \}
  \},
  onexit = TRUE
)
}\if{html}{\out{</div>}}

This approach is only recommended if you are using \code{git}.

Alternatively, you can transition away from using ephemeral python
environemnts via \code{py_require()} to using a persistent local virtual
environment you manage. You can create a local virtual environment from
\code{requirements.txt} and \code{.python-version} using \code{\link[=virtualenv_create]{virtualenv_create()}}:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{# Note: '.venv' in the current directory is auto-discovered by reticulate.
# https://rstudio.github.io/reticulate/articles/versions.html#order-of-discovery
virtualenv_create(
  "./.venv",
  version = readLines(".python-version"),
  requirements = "requirements.txt"
)
}\if{html}{\out{</div>}}

If you run into issues, be aware that \code{requirements.txt} and
\code{.python-version} may not contain all the information necessary to
reproduce the Python environment if the R code sets environment variables
like \code{UV_INDEX} or \code{UV_CONSTRAINT}.
}
