% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fire.R
\name{fire}
\alias{fire}
\title{The FIRE algorithm}
\usage{
fire(r, force, restraint, m = 1, dt = 0.1, maxmove = 100,
  dtmax = 1, Nmin = 5, finc = 1.1, fdec = 0.5, astart = 0.1,
  fa = 0.99, a = 0.1, nstep = 100, tol = 1e-05, verbose = FALSE,
  report = message)
}
\arguments{
\item{r}{Initial locations of particles}

\item{force}{Force function}

\item{restraint}{Restraint function}

\item{m}{Masses of points}

\item{dt}{Initial time step}

\item{maxmove}{Maximum distance to move in any time step}

\item{dtmax}{Maximum time step}

\item{Nmin}{Number of steps after which to start increasing \code{dt}}

\item{finc}{Fractional increase in \code{dt} per time step}

\item{fdec}{Fractional decrease in \code{dt} after a stop}

\item{astart}{Starting value of \code{a} after a stop}

\item{fa}{Fraction of \code{a} to retain after each step}

\item{a}{Initial value of \code{a}}

\item{nstep}{Maximum number of steps}

\item{tol}{Tolerance - if RMS force is below this value, stop and
report convergence}

\item{verbose}{If \code{TRUE} report progress verbosely}

\item{report}{Function to report progress when \code{verbose} is \code{TRUE}}
}
\value{
List containing \code{x}, the positions of the points,
\code{conv}, which is 0 if convergence as occurred and 1 otherwise,
and \code{frms}, the root mean square of the forces on the
particles.
}
\description{
This is an implementation of the FIRE algorithm for structural
relaxation put forward by Bitzek et al. (2006)
}
\references{
Bitzek, E., Koskinen, P., G\"{a}hler, F., Moseler, M.,
and Gumbsch, P. (2006). Structural relaxation made
simple. Phys. Rev. Lett., 97:170201.
}
\author{
David Sterratt
}
