% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getRetrosheet.R
\name{getRetrosheet}
\alias{getRetrosheet}
\title{Import single-season retrosheet data as a structured R object}
\usage{
getRetrosheet(
  type,
  year,
  team,
  schedSplit = NULL,
  stringsAsFactors = FALSE,
  cache = NA
)
}
\arguments{
\item{type}{character.  This argument can take on either of "game" for
game-logs, "play" for play-by-play (a.k.a. event) data, "roster" for
team rosters, or "schedule" for the game schedule for the given year.}

\item{year}{integer. A valid four-digit year.}

\item{team}{character. Only to be used if \code{type = "play"}.
A single valid team ID for the given year. For available team IDs for the
given year call \code{getTeamIDs(year)}.  The available teams
are in the "TeamID" column.}

\item{schedSplit}{One of "Date", "HmTeam", or "TimeOfDay" to return a list
split by the given value, or NULL (the default) for no splitting.}

\item{stringsAsFactors}{logical. The \code{stringsAsFactors} argument as
used in \code{\link[base]{data.frame}}. Currently applicable to types "game" and "schedule".}

\item{cache}{character. Path to locale cache of retrosheet data. If file doesn't exist,
files will be saved locally for future use. Defaults to "NA" so as not to save local data without
explicit permission#'}
}
\value{
The following return values are possible for the given \code{type}
\itemize{
\item \code{game} - a data frame of gamelog data for the given year
\item \code{play} - a list, each element of which is a single game's play-by-play
data for the given team and year.  Each list element is also a list, containing
the play-by-play data split into individual matrices.
\item \code{roster} - a named list, each element containing the roster
for the named team for the given year, as a data frame.
\item \code{schedule} - a data frame containing the game schedule for the given year
}
}
\description{
This function downloads and parses data from \url{http://www.retrosheet.org}
for the game-log, event, (play-by-play), roster, and schedule files.
}
\examples{
\donttest{
## get the full 1995 season schedule
getRetrosheet("schedule", 1995)

## get the same schedule, split by time of day
getRetrosheet("schedule", 1995, schedSplit = "TimeOfDay")

## get the roster data for the 1995 season, listed by team
getRetrosheet("roster", 1995)

## get the full gamelog data for the 2012 season
getRetrosheet("game", 2012)

## get the play-by-play data for the San Francisco Giants' 2012 season
getRetrosheet("play", 2012, "SFN")
}

}
