% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{gp_mdi}
\alias{gp_mdi}
\title{Maximal data information (MDI) prior for GP parameters
(\eqn{\sigma, \xi})}
\usage{
gp_mdi(pars, a = 1, min_xi = -1, max_xi = Inf, trendsd = 0)
}
\arguments{
\item{pars}{A numeric vector of length 3.
GP parameters (\eqn{\sigma, \xi}).}

\item{a}{A numeric scalar.  The default value, Euler's constant, gives the
MDI prior.}

\item{min_xi}{A numeric scalar.  Prior lower bound on \eqn{\xi}.
Must not be \code{-Inf} because this results in an improper posterior.
See Northrop and Attalides (2016) for details.}

\item{max_xi}{A numeric scalar.  Prior upper bound on \eqn{\xi}.}

\item{trendsd}{Has no function other than to achieve compatibility with
function in the evdbayes package.}
}
\value{
The log of the prior density.
}
\description{
For information about this and other priors see \code{\link{set_prior}}.
}
\references{
Northrop, P.J. and Attalides, N. (2016) Posterior propriety in
  Bayesian extreme value analyses using reference priors
  \emph{Statistica Sinica}, \strong{26(2)}, 721--743
  \url{https://doi.org/10.5705/ss.2014.034}.
}
