% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/common_names.R
\name{common_to_sci}
\alias{common_to_sci}
\title{common_to_sci}
\usage{
common_to_sci(x, Language = NULL, ..., server = NULL)
}
\arguments{
\item{x}{a common name or list of common names}

\item{Language}{a string specifying the language for the common name, e.g. "English"}

\item{...}{unused; for backwards compatibility only}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}
}
\value{
a character vector of scientific names
}
\description{
Return a list of scientific names corresponding to given the common name(s).
}
\details{
If more than one scientific name matches the common name (e.g. "trout"), the function
will simply return a list of all matching scientific names.  If given more than one common name,
the resulting strings of matching scientific names are simply concatenated.
}
\examples{
\donttest{
common_to_sci(c("Bicolor cleaner wrasse", "humphead parrotfish"), Language="English")
common_to_sci(c("Coho Salmon", "trout"))
}
}
\seealso{
\code{\link{species_list}}, \code{\link{synonyms}}
}
