% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_fields.R
\name{list_fields}
\alias{list_fields}
\title{list_fields}
\usage{
list_fields(fields = NULL, server = NULL, implemented_only = TRUE)
}
\arguments{
\item{fields}{field (column name) to search for}

\item{server}{base URL to the FishBase API (by default). For SeaLifeBase, use https://fishbase.ropensci.org/sealifebase}

\item{implemented_only}{by default, only return those tables that have been implemented.}
}
\value{
a data frame listing the table names (matching function names in rfishbase) and the matching column names those tables have implemented.
}
\description{
list fields
}
\details{
Calling `list_fields()` with no arguments will return the full table of all known fields.
Then users can employ standard filter techniques like grep for partial name matching; 
see examples.
}
\examples{
\donttest{
list_fields("Temp")

## Regex matching on full table
library(dplyr)
list_fields() \%>\% filter(grepl("length", columns, ignore.case = TRUE))
}
}
