% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/synonyms.R
\name{synonyms}
\alias{synonyms}
\title{synonyms}
\usage{
synonyms(species_list = NULL, server = NULL, ...)
}
\arguments{
\item{species_list}{A vector of scientific names (each element as "genus species"). If empty, a table for all fish will be returned.}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{...}{unused; for backwards compatibility only}
}
\value{
A table with information about the synonym. Will generally be only a single
row if a species name is given.  If a FishBase SpecCode is given, all synonyms matching
that SpecCode are shown, and the table indicates which one is Valid for FishBase. This may
or may not match the valid name for Catalog of Life (Col), also shown in the table. See examples for details.
}
\description{
Check for alternate versions of a scientific name
}
\details{
For further information on fields returned, see:
http://www.fishbase.org/manual/english/fishbasethe_synonyms_table.htm
}
\examples{
\donttest{
# Query using a synonym:
synonyms("Callyodon muricatus")
 
 # Check for misspellings or alternate names
 synonyms("Labroides dimidatus") # Species name misspelled

 # See all synonyms 
 species("Bolbometopon muricatum")
 }
}
