% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/refs.R
\name{references}
\alias{references}
\title{references}
\usage{
references(
  codes = NULL,
  fields = NULL,
  server = getOption("FISHBASE_API", "fishbase"),
  version = get_latest_release(),
  db = default_db(),
  ...
)
}
\arguments{
\item{codes}{One or more Fishbase reference numbers, matching the RefNo 
field}

\item{fields}{a character vector specifying which fields (columns) should be returned. By default,
all available columns recognized by the parser are returned.  Mostly for backwards compatibility as users can subset by column later}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{version}{a version string for the database, will default to the latest release. see [get_releases()] for details.}

\item{db}{the}

\item{...}{unused; for backwards compatibility only}
}
\value{
a tibble (data.frame) of reference data
}
\description{
references
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
 \dontrun{
references(codes = 1)
references(codes = 1:6)
references(codes = 1:6, fields = c('Author', 'Year', 'Title'))
references() # all references
}
\dontshow{\}) # examplesIf}
}
