% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/docs.R
\name{docs}
\alias{docs}
\title{docs}
\usage{
docs(table = NULL, server = NULL, ...)
}
\arguments{
\item{table}{the table for which the documentation should be displayed.  If no table is given,
documentation summarizing all available tables is shown.}

\item{server}{can be set to either "fishbase" or "sealifebase" to switch between databases. NOTE: it is usually
easier to leave this as NULL and set the source instead using the environmental variable `FISHBASE_API`, e.g.
`Sys.setenv(FISHBASE_API="sealifebase")`.}

\item{...}{unused; for backwards compatibility only}
}
\value{
A data.frame which lists the name of each table (if no table argument is given), along with a description
of the table and a URL linking to further information about the table.  If a specific table is named in the
table argument, then the function will return a data.frame listing all the fields (columns) found in that table, 
a description of what the field label means, and the units in which the field is measured.  These descriptions of the
columns are not made available by FishBase and must be manually generated and curated by FishBase users. 
At this time, many fields are still missing.  Please take a moment to fill in any fields you use in the source
table here: https://github.com/ropensci/fishbaseapi/tree/master/docs/docs-sources
}
\description{
documentation of tables and fields
}
\examples{
\dontshow{if (interactive() ) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
tables <- docs()
# Describe the fecundity table
dplyr::filter(tables, table == "fecundity")$description
## See fields in fecundity table
docs("fecundity")
## Note: only 
}
\dontshow{\}) # examplesIf}
}
