/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.strategy.decision;

import org.chocosolver.solver.search.strategy.assignments.DecisionOperator;
import org.chocosolver.solver.search.strategy.assignments.GraphDecisionOperator;
import org.chocosolver.solver.search.strategy.decision.GraphDecision;
import org.chocosolver.solver.search.strategy.decision.IntDecision;
import org.chocosolver.solver.search.strategy.decision.RealDecision;
import org.chocosolver.solver.search.strategy.decision.SetDecision;
import org.chocosolver.solver.variables.GraphVar;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.RealVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.util.PoolManager;

public class DecisionMaker {
    private final PoolManager<IntDecision> intDecisionPool = new PoolManager();
    private final PoolManager<RealDecision> realDecisionPool = new PoolManager();
    private final PoolManager<SetDecision> setDecisionPool = new PoolManager();
    private final PoolManager<GraphDecision> graphDecisionPool = new PoolManager();

    public IntDecision makeIntDecision(IntVar var, DecisionOperator<IntVar> dop, int value) {
        IntDecision d = this.intDecisionPool.getE();
        if (d == null) {
            d = new IntDecision(this.intDecisionPool);
        }
        d.set(var, value, dop);
        return d;
    }

    public RealDecision makeRealDecision(RealVar var, double value, double epsilon, boolean leftFirst) {
        RealDecision d = this.realDecisionPool.getE();
        if (d == null) {
            d = new RealDecision(this.realDecisionPool);
        }
        d.set(var, value, epsilon, leftFirst);
        return d;
    }

    public SetDecision makeSetDecision(SetVar var, DecisionOperator<SetVar> dop, int value) {
        SetDecision d = this.setDecisionPool.getE();
        if (d == null) {
            d = new SetDecision(this.setDecisionPool);
        }
        d.set(var, value, dop);
        return d;
    }

    public <G extends GraphVar<?>> GraphDecision<G> makeGraphNodeDecision(G var, GraphDecisionOperator dop, int node) {
        GraphDecision<G> d = this.graphDecisionPool.getE();
        if (d == null) {
            d = new GraphDecision<G>(this.graphDecisionPool);
        }
        d.setNode(var, node, dop);
        return d;
    }

    public <G extends GraphVar<?>> GraphDecision<G> makeGraphEdgeDecision(G var, GraphDecisionOperator dop, int from, int to) {
        GraphDecision<G> d = this.graphDecisionPool.getE();
        if (d == null) {
            d = new GraphDecision<G>(this.graphDecisionPool);
        }
        d.setEdge(var, from, to, dop);
        return d;
    }
}

