/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.trace;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.trace.SearchViz;

public class GraphvizGenerator
extends SearchViz {
    private static final String OPEN = "digraph G{\n\trankdir=TB;\n\n";
    private static final String ROOT = "\t0 [label=\"ROOT\", shape = doublecircle, color = gray];\n";
    private static final String NODE = "\t%d [label = \"%s\" shape = circle];\n";
    private static final String SOLU = "\ts%d [label = \"Sol.#%d\" shape = box, color = green2];\n";
    private static final String FAIL = "\t%d [shape = point, color = red];\n";
    private static final String EDGE = "\t%d -> %d;\n";
    private static final String SEDGE = "\t%d -> s%d;\n";
    private static final String END = "}";
    private final Path instance;
    private int scount = 0;

    public GraphvizGenerator(String gvFile, Solver aSolver) {
        super(aSolver, false);
        this.instance = Paths.get(gvFile, new String[0]);
        if (Files.exists(this.instance, new LinkOption[0])) {
            try {
                Files.delete(this.instance);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            Files.createFile(this.instance, new FileAttribute[0]);
            Files.write(this.instance, OPEN.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Unable to create to GEXF file. No information will be sent.");
            this.connected = false;
        }
        this.connected = true;
    }

    @Override
    protected boolean connect(String label) {
        return true;
    }

    @Override
    protected void disconnect() {
        try {
            Files.write(this.instance, END.getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void sendNode(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        if (pid == -1) {
            try {
                Files.write(this.instance, ROOT.getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                System.err.println("Unable to write to GEXF file. No information will be sent.");
                this.connected = false;
            }
        } else {
            try {
                Files.write(this.instance, String.format(NODE, nc, label).getBytes(), StandardOpenOption.APPEND);
                Files.write(this.instance, String.format(EDGE, pid, nc).getBytes(), StandardOpenOption.APPEND);
            }
            catch (IOException e) {
                System.err.println("Unable to write to GEXF file. No information will be sent.");
                this.connected = false;
            }
        }
    }

    @Override
    protected void sendSolution(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        this.sendNode(nc, pid, alt, kid, rid, label, info);
        try {
            Files.write(this.instance, String.format(SOLU, ++this.scount, this.scount).getBytes(), StandardOpenOption.APPEND);
            Files.write(this.instance, String.format(SEDGE, nc, this.scount).getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Unable to write to GEXF file. No information will be sent.");
            this.connected = false;
        }
    }

    @Override
    protected void sendFailure(int nc, int pid, int alt, int kid, int rid, String label, String info) {
        try {
            Files.write(this.instance, String.format(FAIL, nc).getBytes(), StandardOpenOption.APPEND);
            Files.write(this.instance, String.format(EDGE, pid, nc).getBytes(), StandardOpenOption.APPEND);
        }
        catch (IOException e) {
            System.err.println("Unable to write to GEXF file. No information will be sent.");
            this.connected = false;
        }
    }

    @Override
    protected void sendRestart(int rid) {
    }
}

