% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chapters-auto.R
\name{ch11}
\alias{ch11}
\title{Print examples of chapter 11 of 'R for Dummies'.}
\usage{
ch11()
}
\description{
To print a listing of all examples of a chapter, use \code{ch11()}.
To run all the examples of \code{ch11()}, use \code{example(ch11)}.
}
\examples{
# Chapter 11 - Getting Help


# Finding Information in the R Help Files

## When you know exactly what you're looking for

?date

## When you don't know exactly what you're looking for

??date


# Searching the Web for Help with R

\dontrun{
RSiteSearch("cluster analysis")
}

\dontrun{
install.packages("sos")
}
library("sos")
\dontrun{
findFn("cluster")
}

# Getting Involved in the R Community

## Using the R mailing lists

## Discussing R on Stack Overflow and Stack Exchange

## Tweeting about R

# Making a Minimal Reproducible Example

dput(cars[1:4, ])

## Creating sample data with random values

set.seed(1)
x <- rnorm(5)
x

cards <- c(1:9, "J", "Q", "K", "A")
suits <- c("Spades", "Diamonds", "Hearts", "Clubs")
deck <- paste(rep(suits, each=13), cards)
set.seed(123)
sample(deck, 7)

set.seed(5)
sample(LETTERS[1:3], 12, replace=TRUE)

set.seed(42)
dat <- data.frame(
   x = sample(1:5),
   y = sample(c("yes", "no"), 5, replace = TRUE)
)
dat

dput(cars[1:4, ])

## Producing minimal code

## Providing the necessary information

sessionInfo()
}
\seealso{
\code{\link{toc}}

Other Chapters: \code{\link{ch01}}, \code{\link{ch02}},
  \code{\link{ch03}}, \code{\link{ch04}},
  \code{\link{ch05}}, \code{\link{ch06}},
  \code{\link{ch07}}, \code{\link{ch08}},
  \code{\link{ch09}}, \code{\link{ch10}},
  \code{\link{ch12}}, \code{\link{ch13}},
  \code{\link{ch14}}, \code{\link{ch15}},
  \code{\link{ch16}}, \code{\link{ch17}},
  \code{\link{ch18}}, \code{\link{ch19}},
  \code{\link{ch20}}
}
\concept{Chapters}
