% Generated by roxygen2 (4.0.0): do not edit by hand
\name{gs_shares}
\alias{gs_shares}
\title{Lists the people that have access to a Gauge.}
\usage{
gs_shares(id, key = NULL, keyname = "GaugesKey", callopts = list())
}
\arguments{
  \item{id}{Your gaug.es id}

  \item{key}{API key. If left NULL, function looks for key
  in your options settings defined in the keyname
  parameter}

  \item{keyname}{Your API key name in your .Rprofile file}

  \item{callopts}{Curl debugging options passed in to
  httr::GET}
}
\description{
Lists the people that have access to a Gauge.
}
\note{
Note that these examples only work if you provide your
		Gaug.es API key either by passing in the function, or
		storing your key in your .Rprofile file, defaults to looking
		for an entry of "GaugesKey".
}
\examples{
\dontrun{
gs_shares(id='4efd83a6f5a1f5158a000004')

# Get list of gauge's, then pass in one of the ids
out <- gs_gauge_list()
gs_shares(id=out$brief[1,'id'])
}
}

