% Generated by roxygen2 (4.0.2): do not edit by hand
\name{nodes}
\alias{nodes}
\title{Nodes metadata.}
\usage{
nodes(data = "all", uuid = NULL, query = NULL, identifier = NULL,
  identifierType = NULL, limit = 100, start = NULL, isocode = NULL, ...)
}
\arguments{
\item{data}{The type of data to get. Default is all data.}

\item{uuid}{UUID of the data node provider. This must be specified if data
is anything other than 'all'.}

\item{query}{Query nodes. Only used when data='all'}

\item{identifier}{The value for this parameter can be a simple string or integer,
e.g. identifier=120. This parameter doesn't seem to work right now.}

\item{identifierType}{Used in combination with the identifier parameter to filter
   identifiers by identifier type. See details. This parameter doesn't seem to
   work right now.}

\item{limit}{Number of records to return. Defaults: For \code{\link{occ_search}} 500, for others
100. Maximum: 1,000,000 records for \code{\link{occ_search}}, others, don't know yet.}

\item{start}{Record number to start at. Use in combination with limit to page through results.
Note that in \code{\link{occ_search}} we do the paging internally for you, so there's no
\code{start} parameeter, but in other functions you have to do paging yourself.}

\item{isocode}{A 2 letter country code. Only used if data='country'.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will
be combined with \code{\link[httr]{config}}.}
}
\description{
Nodes metadata.
}
\details{
identifierType options:

\itemize{
 \item {DOI} No description.
 \item {FTP} No description.
 \item {GBIF_NODE} Identifies the node (e.g: 'DK' for Denmark, 'sp2000' for Species 2000).
 \item {GBIF_PARTICIPANT} Participant identifier from the GBIF IMS Filemaker system.
 \item {GBIF_PORTAL} Indicates the identifier originated from an auto_increment column in the
 portal.data_provider or portal.data_resource table respectively.
 \item {HANDLER} No description.
 \item {LSID} Reference controlled by a separate system, used for example by DOI.
 \item {SOURCE_ID} No description.
 \item {UNKNOWN} No description.
 \item {URI} No description.
 \item {URL} No description.
 \item {UUID} No description.
}
}
\examples{
\dontrun{
nodes(limit=5)
nodes(uuid="1193638d-32d1-43f0-a855-8727c94299d8")
nodes(data='identifier', uuid="03e816b3-8f58-49ae-bc12-4e18b358d6d9")
nodes(data=c('identifier','organization','comment'), uuid="03e816b3-8f58-49ae-bc12-4e18b358d6d9")

uuids = c("8cb55387-7802-40e8-86d6-d357a583c596","02c40d2a-1cba-4633-90b7-e36e5e97aba8",
"7a17efec-0a6a-424c-b743-f715852c3c1f","b797ce0f-47e6-4231-b048-6b62ca3b0f55",
"1193638d-32d1-43f0-a855-8727c94299d8","d3499f89-5bc0-4454-8cdb-60bead228a6d",
"cdc9736d-5ff7-4ece-9959-3c744360cdb3","a8b16421-d80b-4ef3-8f22-098b01a89255",
"8df8d012-8e64-4c8a-886e-521a3bdfa623","b35cf8f1-748d-467a-adca-4f9170f20a4e",
"03e816b3-8f58-49ae-bc12-4e18b358d6d9","073d1223-70b1-4433-bb21-dd70afe3053b",
"07dfe2f9-5116-4922-9a8a-3e0912276a72","086f5148-c0a8-469b-84cc-cce5342f9242",
"0909d601-bda2-42df-9e63-a6d51847ebce","0e0181bf-9c78-4676-bdc3-54765e661bb8",
"109aea14-c252-4a85-96e2-f5f4d5d088f4","169eb292-376b-4cc6-8e31-9c2c432de0ad",
"1e789bc9-79fc-4e60-a49e-89dfc45a7188","1f94b3ca-9345-4d65-afe2-4bace93aa0fe")

library('plyr')
res <- lapply(uuids, function(x) nodes(x, data='identifier')$data)
res <- res[!sapply(res, length)==0]
ldply(res)

# Pass on options to httr
library('httr')
res <- nodes(limit=20, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/registry#nodes}
}

