% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/occ_get.r
\name{occ_get}
\alias{occ_get}
\title{Get data for specific GBIF occurrences.}
\usage{
occ_get(key = NULL, return = "all", verbatim = FALSE,
  fields = "minimal", ...)
}
\arguments{
\item{key}{Occurrence key}

\item{return}{One of data, hier, meta, or all. If 'data', a data.frame with the
data. 'hier' returns the classifications in a list for each record. meta
returns the metadata for the entire call. 'all' gives all data back in a list.
Ignored if \code{verbatim=TRUE}.}

\item{verbatim}{Return verbatim object (TRUE) or cleaned up object (FALSE, default).}

\item{fields}{(character) Default ('minimal') will return just taxon name, key, latitude, and
longitute. 'all' returns all fields. Or specify each field you want returned by name, e.g.
fields = c('name','decimalLatitude','altitude').}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc, passed on to
\code{\link[httr]{modify_url}} within \code{\link[httr]{GET}} call. Unnamed parameters will be
combined with \code{\link[httr]{config}}.}
}
\value{
A data.frame or list of data.frame's.
}
\description{
Get data for specific GBIF occurrences.
}
\examples{
\dontrun{
occ_get(key=766766824, return='data')
occ_get(key=766766824, 'hier')
occ_get(key=766766824, 'all')

# many occurrences
occ_get(key=c(101010, 240713150, 855998194), return='data')

# Verbatim data
occ_get(key=766766824, verbatim=TRUE)
occ_get(key=766766824, fields='all', verbatim=TRUE)
occ_get(key=766766824, fields=c('scientificName', 'lastCrawled', 'county'), verbatim=TRUE)
occ_get(key=c(766766824, 620594291, 766420684), verbatim=TRUE)
occ_get(key=c(766766824, 620594291, 766420684), fields='all', verbatim=TRUE)
occ_get(key=c(766766824, 620594291, 766420684),
   fields=c('scientificName', 'decimalLatitude', 'basisOfRecord'), verbatim=TRUE)

# Pass in curl options
library("httr")
occ_get(key=766766824, config=verbose())
occ_get(key=766766824, config=progress())
}
}
\references{
\url{http://www.gbif.org/developer/occurrence#occurrence}
}

